/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.model.AbstractBackReference;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.MultiBackReferenceEntry;
import ch.nolix.system.objectdata.modelexaminer.FieldExaminer;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.modelexaminer.IDatabaseObjectExaminer;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.model.IAbstractReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiBackReferenceEntry;
import ch.nolix.systemapi.objectdata.modelexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;

public final class MultiBackReference<E extends IEntity>
extends AbstractBackReference<E>
implements IMultiBackReference<E> {
    private static final IDatabaseObjectExaminer DATABASE_OBJECT_EXAMINER = new DatabaseObjectExaminer();
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private boolean loadedAllPersistedBackReferencedEntityIds;
    private final ILinkedList<MultiBackReferenceEntry<E>> localEntries = LinkedList.createEmpty();

    private MultiBackReference(String backReferencedTableName, String backReferencedBaseReferenceName) {
        super(backReferencedTableName, backReferencedBaseReferenceName);
    }

    public static <E2 extends AbstractEntity> MultiBackReference<E2> forBackReferencedEntityTypeAndBaseReference(Class<E2> backReferencedEntityType, String backReferencedBaseReferenceName) {
        String entityTypeName = backReferencedEntityType.getSimpleName();
        return MultiBackReference.forBackReferencedTableAndBaseReference(entityTypeName, backReferencedBaseReferenceName);
    }

    public static <E2 extends AbstractEntity> MultiBackReference<E2> forBackReferencedTableAndBaseReference(String backReferencedTableName, String backReferencedBaseReference) {
        return new MultiBackReference(backReferencedTableName, backReferencedBaseReference);
    }

    @Override
    public IContainer<String> getAllBackReferencedEntityIds() {
        this.updateStateLoadingAllPersistedBackReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrLoadedOrEdited).to(IMultiBackReferenceEntry::getBackReferencedEntityId);
    }

    @Override
    public IContainer<E> getAllStoredBackReferencedEntities() {
        this.updateStateLoadingAllPersistedBackReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrLoadedOrEdited).to(IMultiBackReferenceEntry::getStoredBackReferencedEntity);
    }

    @Override
    public IContainer<? extends IMultiBackReferenceEntry<E>> getStoredNewAndDeletedEntries() {
        return this.localEntries.getStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrDeleted);
    }

    @Override
    public IContainer<IAbstractReference<IEntity>> getStoredAbstractReferencesThatAreBackReferencedFromThis() {
        LinkedList<IAbstractReference<IEntity>> abstractReferences = LinkedList.createEmpty();
        String backReferencedBaseReferenceName = this.getBackReferencedFieldName();
        for (IEntity e : this.getAllStoredBackReferencedEntities()) {
            IAbstractReference backReferencedField = (IAbstractReference)ENTITY_SEARCHER.getStoredFieldByName(e, backReferencedBaseReferenceName);
            abstractReferences.addAtEnd(backReferencedField);
        }
        return abstractReferences;
    }

    @Override
    public ContentType getType() {
        return ContentType.MULTI_BACK_REFERENCE;
    }

    @Override
    public IContainer<IField> internalGetStoredSubFields() {
        return ImmutableList.createEmpty();
    }

    @Override
    public void internalSetOptionalContent(Object content) {
        Validator.assertThat(content).thatIsNamed("content").isNull();
    }

    @Override
    public boolean isEmpty() {
        return this.localEntries.isEmpty() && this.isEmptyWhenDoesNotHaveLocalEntries();
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean loadedAllPersistedReferencedEntityIds() {
        return this.loadedAllPersistedBackReferencedEntityIds;
    }

    @Override
    public boolean referencesBackEntity(IEntity entity) {
        String backReferencedBaseReferenceName = this.getBackReferencedFieldName();
        for (IField iField : entity.internalGetStoredFields()) {
            if (!iField.hasName(backReferencedBaseReferenceName)) continue;
            return iField.referencesEntity(entity);
        }
        return false;
    }

    @Override
    public boolean referencesBackEntityWithId(String id) {
        Object entity = this.getStoredBackReferencedTable().getStoredEntityById(id);
        return this.referencesBackEntity((IEntity)entity);
    }

    void internalAddBackReferencedEntityId(String backReferencedEntityId) {
        MultiBackReferenceEntry newEntry = MultiBackReferenceEntry.newEntryForMultiBackReferenceAndReferencedEntityId(this, backReferencedEntityId);
        this.localEntries.addAtEnd(newEntry);
    }

    void internalDeleteBackReferencedEntityId(String backReferencedEntityId) {
        MultiBackReferenceEntry entry = this.localEntries.getStoredFirst(e -> e.getBackReferencedEntityId().equals(backReferencedEntityId));
        entry.internalDelete();
    }

    private boolean isEmptyWhenDoesNotHaveLocalEntries() {
        return this.getAllStoredBackReferencedEntities().isEmpty();
    }

    private IContainer<MultiBackReferenceEntry<E>> loadAllPersistedBackReferencedEntityIds() {
        AbstractEntity entity = this.getStoredParentEntity();
        return this.getStoredDataAndSchemaAdapter().loadMultiBackReferenceBackReferencedEntityIds(entity.getParentTableName(), entity.getId(), this.getName()).to(e -> MultiBackReferenceEntry.loadedEntryForMultiBackReferenceAndReferencedEntityId(this, e));
    }

    private boolean needsToLoadAllPersistedBackReferencedEntityIds() {
        return !this.loadedAllPersistedReferencedEntityIds() && FIELD_EXAMINER.belongsToLoadedEntity(this);
    }

    private void updateStateLoadingAllPersistedBackReferencedEntityIds() {
        this.loadedAllPersistedBackReferencedEntityIds = true;
        this.localEntries.addAtEnd(this.loadAllPersistedBackReferencedEntityIds());
    }

    private void updateStateLoadingAllPersistedBackReferencedEntityIdsIfNotLoaded() {
        if (this.needsToLoadAllPersistedBackReferencedEntityIds()) {
            this.updateStateLoadingAllPersistedBackReferencedEntityIds();
        }
    }
}

