/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiBackReferenceEntry;

public final class MultiBackReferenceEntry<E extends IEntity>
implements IMultiBackReferenceEntry<E> {
    private final IMultiBackReference<E> parentMultiBackReference;
    private DatabaseObjectState state;
    private final String backReferencedEntityId;

    private MultiBackReferenceEntry(IMultiBackReference<E> parentMultiBackReference, DatabaseObjectState initialState, String backReferencedEntityId) {
        Validator.assertThat(parentMultiBackReference).thatIsNamed("parent MultiBackReference").isNotNull();
        Validator.assertThat(initialState).thatIsNamed("initial state").isNotNull();
        Validator.assertThat(backReferencedEntityId).thatIsNamed("back referenced entity id").isNotBlank();
        this.parentMultiBackReference = parentMultiBackReference;
        this.state = initialState;
        this.backReferencedEntityId = backReferencedEntityId;
    }

    public static <E2 extends IEntity> MultiBackReferenceEntry<E2> loadedEntryForMultiBackReferenceAndReferencedEntityId(IMultiBackReference<E2> multiBackReference, String backReferencedEntityId) {
        return new MultiBackReferenceEntry<E2>(multiBackReference, DatabaseObjectState.LOADED, backReferencedEntityId);
    }

    public static <E2 extends IEntity> MultiBackReferenceEntry<E2> newEntryForMultiBackReferenceAndReferencedEntityId(IMultiBackReference<E2> multiBackReference, String backReferencedEntityId) {
        return new MultiBackReferenceEntry<E2>(multiBackReference, DatabaseObjectState.NEW, backReferencedEntityId);
    }

    @Override
    public String getBackReferencedEntityId() {
        return this.backReferencedEntityId;
    }

    @Override
    public DatabaseObjectState getState() {
        return switch ((DatabaseObjectState)((Object)this.getStoredParentMultiBackReference().getState())) {
            case DatabaseObjectState.NEW -> DatabaseObjectState.NEW;
            case DatabaseObjectState.DELETED -> DatabaseObjectState.DELETED;
            case DatabaseObjectState.CLOSED -> DatabaseObjectState.CLOSED;
            default -> this.state;
        };
    }

    @Override
    public E getStoredBackReferencedEntity() {
        return this.getStoredParentMultiBackReference().getStoredBackReferencedTable().getStoredEntityById(this.getBackReferencedEntityId());
    }

    @Override
    public IMultiBackReference<E> getStoredParentMultiBackReference() {
        return this.parentMultiBackReference;
    }

    @Override
    public boolean isClosed() {
        return this.getStoredParentMultiBackReference().isClosed();
    }

    @Override
    public boolean isDeleted() {
        return this.getStoredParentMultiBackReference().isDeleted();
    }

    @Override
    public boolean isEdited() {
        return false;
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.getStoredParentMultiBackReference().isConnectedWithRealDatabase();
    }

    @Override
    public boolean isLoaded() {
        return this.getState() == DatabaseObjectState.LOADED;
    }

    @Override
    public boolean isNew() {
        return this.getState() == DatabaseObjectState.NEW;
    }

    void internalDelete() {
        this.state = DatabaseObjectState.DELETED;
    }
}

