/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.fieldtool.MultiReferenceEntryTool;
import ch.nolix.system.objectdata.fieldtool.MultiReferenceTool;
import ch.nolix.system.objectdata.fieldvalidator.MultiReferenceValidator;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.AbstractReference;
import ch.nolix.system.objectdata.model.BaseReferenceUpdater;
import ch.nolix.system.objectdata.model.MultiReferenceEntry;
import ch.nolix.system.objectdata.modelexaminer.FieldExaminer;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.model.IAbstractBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiReferenceEntry;
import ch.nolix.systemapi.objectdata.modelexaminer.IFieldExaminer;
import java.util.Optional;
import java.util.function.Predicate;

public final class MultiReference<E extends IEntity>
extends AbstractReference<E>
implements IMultiReference<E> {
    private static final BaseReferenceUpdater BASE_BACK_REFERENCE_UPDATER = new BaseReferenceUpdater();
    private static final MultiReferenceTool MULTI_REFERENCE_TOOL = new MultiReferenceTool();
    private static final MultiReferenceValidator MULTI_REFERENCE_VALIDATOR = new MultiReferenceValidator();
    private static final MultiReferenceEntryTool MULTI_REFERENCE_ENTRY_TOOL = new MultiReferenceEntryTool();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private boolean loadedAllPersistedReferencedEntityIds;
    private final LinkedList<MultiReferenceEntry<E>> localEntries = LinkedList.createEmpty();

    private MultiReference(String referencedTableName) {
        super(referencedTableName);
    }

    public static <E2 extends AbstractEntity> MultiReference<E2> forEntity(Class<E2> referencedEntityType) {
        String referencedTableName = referencedEntityType.getSimpleName();
        return new MultiReference(referencedTableName);
    }

    public static <E2 extends AbstractEntity> MultiReference<E2> forTable(String referencedTableName) {
        return new MultiReference(referencedTableName);
    }

    @Override
    public void addEntity(Object entity) {
        this.addCastedEntity((IEntity)entity);
    }

    @Override
    public void clear() {
        this.getAllStoredReferencedEntities().forEach(this::removeEntity);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    @Override
    public IContainer<String> getAllReferencedEntityIds() {
        this.updateStateLoadingAllPersistedReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getStoredSelected(MULTI_REFERENCE_TOOL::isNewOrLoadedOrEdited).to(IMultiReferenceEntry::getReferencedEntityId);
    }

    @Override
    public IContainer<E> getAllStoredReferencedEntities() {
        this.updateStateLoadingAllPersistedReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getStoredSelected(MULTI_REFERENCE_TOOL::isNewOrLoadedOrEdited).to(IMultiReferenceEntry::getStoredReferencedEntity);
    }

    @Override
    public IContainer<IAbstractBackReference<IEntity>> getStoredAbstractBackReferencesThatReferencesBackThis() {
        LinkedList<IAbstractBackReference<IEntity>> abstractBackReferences = LinkedList.createEmpty();
        for (IEntity e : this.getAllStoredReferencedEntities()) {
            IContainer<? extends IField> fields = e.internalGetStoredFields();
            Optional<IField> abstractBackReferenceContainer = fields.getOptionalStoredFirst(f -> f.referencesBackField(this));
            if (!abstractBackReferenceContainer.isPresent()) continue;
            IAbstractBackReference abstractBackReference = (IAbstractBackReference)abstractBackReferenceContainer.get();
            abstractBackReferences.addAtEnd(abstractBackReference);
        }
        return abstractBackReferences;
    }

    @Override
    public IContainer<? extends IMultiReferenceEntry<E>> getStoredNewAndDeletedEntries() {
        return this.localEntries.getStoredSelected(MULTI_REFERENCE_ENTRY_TOOL::isNewOrDeleted);
    }

    @Override
    public ContentType getType() {
        return ContentType.MULTI_REFERENCE;
    }

    @Override
    public IContainer<IField> internalGetStoredSubFields() {
        return ImmutableList.createEmpty();
    }

    @Override
    public void internalSetOptionalContent(Object content) {
        Validator.assertThat(content).thatIsNamed("content").isNull();
    }

    @Override
    public boolean isEmpty() {
        return this.getAllReferencedEntityIds().isEmpty();
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean loadedAllPersistedReferencedEntityIds() {
        return this.loadedAllPersistedReferencedEntityIds;
    }

    @Override
    public boolean referencesEntity(IEntity entity) {
        if (entity == null) {
            return false;
        }
        return this.getAllReferencedEntityIds().containsEqualing(entity.getId());
    }

    @Override
    public boolean referencesUninsertedEntity() {
        return this.getAllStoredReferencedEntities().containsAny(e -> !e.belongsToTable());
    }

    @Override
    public void removeEntity(Object entity) {
        this.removeCastedEntity((IEntity)entity);
    }

    @Override
    public void removeFirstEntity(Predicate<E> selector) {
        Optional<E> entity = this.getAllStoredReferencedEntities().getOptionalStoredFirst(selector);
        entity.ifPresent(this::removeEntity);
    }

    @Override
    protected void internalUpdateBackReferencingFieldsWhenIsInsertedIntoDatabase() {
        if (this.containsAny()) {
            for (IEntity e : this.getAllStoredReferencedEntities()) {
                this.updateProbableBackReferenceForSetOrAddedEntity(e);
            }
        }
    }

    private void addCastedEntity(E entity) {
        this.assertCanAddEntity(entity);
        this.updateStateAddingEntity(entity);
        this.updatePotentialBaseBackReferenceOfEntityForAddEntity(entity);
        this.insertEntityIntoDatabaseIfPossible(entity);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private void assertCanAddEntity(E entity) {
        MULTI_REFERENCE_VALIDATOR.assertCanAddGivenEntity(this, (IEntity)entity);
    }

    private void insertEntityIntoDatabaseIfPossible(E entity) {
        if (this.belongsToEntity() && this.getStoredParentEntity().belongsToTable() && entity.getState() == DatabaseObjectState.NEW && !entity.belongsToTable()) {
            this.getStoredParentEntity().getStoredParentDatabase().insertEntity(entity);
        }
    }

    private IContainer<MultiReferenceEntry<E>> loadAllPersistedReferencedEntityIds() {
        return this.getStoredDataAndSchemaAdapter().loadMultiReferenceEntries(this.getStoredParentEntity().getParentTableName(), this.getStoredParentEntity().getId(), this.getName()).to(rei -> MultiReferenceEntry.loadedEntryForMultiReferenceAndReferencedEntityId(this, rei.referencedEntityId()));
    }

    private boolean needsToLoadAllPersistedReferencedEntityIds() {
        return !this.loadedAllPersistedReferencedEntityIds() && FIELD_EXAMINER.belongsToLoadedEntity(this);
    }

    private void removeCastedEntity(E entity) {
        MULTI_REFERENCE_VALIDATOR.assertCanRemoveEntity(this, entity);
        this.updateStateLoadingAllPersistedReferencedEntityIdsIfNotLoaded();
        this.localEntries.getStoredFirst(le -> le.getReferencedEntityId().equals(entity.getId())).internalSetDeleted();
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private void updatePotentialBaseBackReferenceOfEntityForAddEntity(E entity) {
        BASE_BACK_REFERENCE_UPDATER.ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(this, entity);
    }

    private void updateStateAddingEntity(E entity) {
        this.localEntries.addAtEnd(MultiReferenceEntry.newEntryForMultiReferenceAndReferencedEntityId(this, entity.getId()));
    }

    private void updateStateLoadingAllPersistedReferencedEntityIds() {
        this.loadedAllPersistedReferencedEntityIds = true;
        this.localEntries.addAtEnd(this.loadAllPersistedReferencedEntityIds());
    }

    private void updateStateLoadingAllPersistedReferencedEntityIdsIfNotLoaded() {
        if (this.needsToLoadAllPersistedReferencedEntityIds()) {
            this.updateStateLoadingAllPersistedReferencedEntityIds();
        }
    }
}

