/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.fieldvalidator.MultiValueValidator;
import ch.nolix.system.objectdata.model.AbstractValueField;
import ch.nolix.system.objectdata.model.MultiValueFieldEntry;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.model.IMultiValueField;
import ch.nolix.systemapi.objectdata.model.IMultiValueFieldEntry;
import java.util.Optional;
import java.util.function.Predicate;

public final class MultiValueField<V>
extends AbstractValueField<V>
implements IMultiValueField<V> {
    private static final DatabaseObjectExaminer DATABASE_OBJECT_TOOL = new DatabaseObjectExaminer();
    private static final MultiValueValidator MULTI_VALUE_VALIDATOR = new MultiValueValidator();
    private boolean loadedAllPersistedValues;
    private final LinkedList<MultiValueFieldEntry<V>> localEntries = LinkedList.createEmpty();

    private MultiValueField(Class<V> valueType) {
        super(valueType);
    }

    public static <V2> MultiValueField<V2> withValueType(Class<V2> valueType) {
        return new MultiValueField<V2>(valueType);
    }

    @Override
    public void addValue(V value) {
        this.assertCanAddValue(value);
        this.updateStateForAddValue(value);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    @Override
    public void clear() {
        this.getAllStoredValues().forEach(this::removeValue);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    @Override
    public IContainer<V> getAllStoredValues() {
        this.updateStateForLoadAllPersistedValuesIfNotLoaded();
        return this.getStoredValuesFromAllNewOrLoadedOrEditedLocalEntries();
    }

    @Override
    public IContainer<? extends IMultiValueFieldEntry<V>> getStoredNewAndDeletedEntries() {
        return this.localEntries.getStoredSelected(DATABASE_OBJECT_TOOL::isNewOrDeleted);
    }

    @Override
    public ContentType getType() {
        return ContentType.MULTI_VALUE;
    }

    @Override
    public void internalSetOptionalContent(Object content) {
        Validator.assertThat(content).thatIsNamed("content").isNull();
    }

    @Override
    public boolean isEmpty() {
        return this.localEntries.isEmpty() && this.isEmptyWhenDoesNotHaveLocalEntries();
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean loadedAllPersistedValues() {
        return this.loadedAllPersistedValues;
    }

    @Override
    public void removeFirstValue(Predicate<V> selector) {
        Optional<V> value = this.getAllStoredValues().getOptionalStoredFirst(selector);
        value.ifPresent(this::removeValue);
    }

    @Override
    public void removeValue(V value) {
        MULTI_VALUE_VALIDATOR.assertCanRemoveValue(this, value);
        this.updateStateForLoadAllPersistedValuesIfNotLoaded();
        this.updateStateForRemoveValue(value);
    }

    private void assertCanAddValue(V value) {
        MULTI_VALUE_VALIDATOR.assertCanAddGivenValue(this, value);
    }

    private IContainer<V> getStoredValuesFromAllNewOrLoadedOrEditedLocalEntries() {
        LinkedList values = LinkedList.createEmpty();
        for (MultiValueFieldEntry multiValueFieldEntry : this.localEntries) {
            if (!DATABASE_OBJECT_TOOL.isNewOrLoadedOrEdited(multiValueFieldEntry)) continue;
            values.addAtEnd(multiValueFieldEntry.getStoredValue());
        }
        return values;
    }

    private boolean isEmptyWhenDoesNotHaveLocalEntries() {
        return this.getAllStoredValues().isEmpty();
    }

    private IContainer<MultiValueFieldEntry<V>> loadAllPersistedValues() {
        return this.getStoredDataAndSchemaAdapter().loadMultiValueValues(this.getStoredParentEntity().getParentTableName(), this.getStoredParentEntity().getId(), this.getName()).to(mve -> MultiValueFieldEntry.loadedEntryForMultiValueAndValue(this, mve));
    }

    private void updateStateForAddValue(V value) {
        MultiValueFieldEntry<V> newEntry = MultiValueFieldEntry.newEntryForMultiValueAndValue(this, value);
        this.localEntries.addAtEnd(newEntry);
    }

    private void updateStateForLoadAllPersistedValues() {
        this.loadedAllPersistedValues = true;
        this.localEntries.addAtEnd(this.loadAllPersistedValues());
    }

    private void updateStateForLoadAllPersistedValuesIfNotLoaded() {
        if (!this.loadedAllPersistedValues()) {
            this.updateStateForLoadAllPersistedValues();
        }
    }

    private void updateStateForRemoveValue(V value) {
        MultiValueFieldEntry entry = this.localEntries.getStoredFirst(e -> e.getStoredValue() == value);
        entry.internalSetDeleted();
    }
}

