/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.fieldtool.OptionalReferenceTool;
import ch.nolix.system.objectdata.fieldvalidator.OptionalReferenceValidator;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.AbstractReference;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.BaseReferenceUpdater;
import ch.nolix.system.objectdata.model.Entity;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.fieldtool.IOptionalReferenceTool;
import ch.nolix.systemapi.objectdata.fieldvalidator.IOptionalReferenceValidator;
import ch.nolix.systemapi.objectdata.model.IAbstractBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IOptionalReference;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import java.util.Optional;

public final class OptionalReference<E extends IEntity>
extends AbstractReference<E>
implements IOptionalReference<E> {
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final BaseReferenceUpdater BASE_BACK_REFERENCE_UPDATER = new BaseReferenceUpdater();
    private static final IOptionalReferenceValidator OPTIONAL_REFERENCE_VALIDATOR = new OptionalReferenceValidator();
    private static final IOptionalReferenceTool OPTIONAL_REFERENCE_TOOL = new OptionalReferenceTool();
    private String referencedEntityId;

    private OptionalReference(String referencedTableName) {
        super(referencedTableName);
    }

    public static <E2 extends Entity> OptionalReference<E2> forEntity(Class<E2> referencedEntityType) {
        String referencedTableName = referencedEntityType.getSimpleName();
        return new OptionalReference(referencedTableName);
    }

    public static OptionalReference<AbstractEntity> forTable(String referencedTableName) {
        return new OptionalReference<AbstractEntity>(referencedTableName);
    }

    @Override
    public void clear() {
        if (this.containsAny()) {
            this.clearWhenContainsAny();
        }
    }

    @Override
    public String getReferencedEntityId() {
        OPTIONAL_REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        return this.referencedEntityId;
    }

    @Override
    public IContainer<IAbstractBackReference<IEntity>> getStoredAbstractBackReferencesThatReferencesBackThis() {
        if (this.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        IContainer<? extends IField> fields = this.getStoredReferencedEntity().internalGetStoredFields();
        Optional<IField> abstractBackReferenceContainer = fields.getOptionalStoredFirst(f -> f.referencesBackField(this));
        if (abstractBackReferenceContainer.isPresent()) {
            IAbstractBackReference abstractBackReference = (IAbstractBackReference)abstractBackReferenceContainer.get();
            return ImmutableList.withElement(abstractBackReference, new IAbstractBackReference[0]);
        }
        return ImmutableList.createEmpty();
    }

    @Override
    public E getStoredReferencedEntity() {
        return this.getStoredReferencedTable().getStoredEntityById(this.getReferencedEntityId());
    }

    @Override
    public ContentType getType() {
        return ContentType.OPTIONAL_REFERENCE;
    }

    @Override
    public IContainer<IField> internalGetStoredSubFields() {
        return ImmutableList.createEmpty();
    }

    @Override
    public void internalSetOptionalContent(Object content) {
        this.referencedEntityId = content == null ? null : (String)content;
    }

    @Override
    public boolean isEmpty() {
        return this.referencedEntityId == null;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean referencesEntity(IEntity entity) {
        return this.containsAny() && entity != null && this.getReferencedEntityId().equals(entity.getId());
    }

    @Override
    public boolean referencesUninsertedEntity() {
        return this.containsAny() && !this.getStoredReferencedEntity().belongsToTable();
    }

    @Override
    public void setEntity(Object entity) {
        this.setCastedEntity((IEntity)entity);
    }

    @Override
    public void setEntityById(String id) {
        Object entity = this.getStoredReferencedTable().getStoredEntityById(id);
        this.setEntity(entity);
    }

    @Override
    protected void internalUpdateBackReferencingFieldsWhenIsInsertedIntoDatabase() {
        if (this.containsAny()) {
            this.updateProbableBackReferenceForSetOrAddedEntity(this.getStoredReferencedEntity());
        }
    }

    private void assertCanClear() {
        OPTIONAL_REFERENCE_VALIDATOR.assertCanClear(this);
    }

    private void assertCanSetEntity(E entity) {
        OPTIONAL_REFERENCE_VALIDATOR.assertCanSetGivenEntity(this, (IEntity)entity);
    }

    private void clearWhenContainsAny() {
        this.assertCanClear();
        this.updateProbableBackReferencingFieldForClear();
        this.updateStateForClear();
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private Optional<? extends IField> getOptionalPendantReferencingFieldToEntity(E entity) {
        return ENTITY_SEARCHER.getStoredFieldsThatAreBackReferencedFrom((IEntity)entity).getOptionalStoredFirst(f -> f.hasName(this.getName()));
    }

    private void insertEntityIntoDatabaseIfPossible(E entity) {
        if (this.belongsToEntity() && this.getStoredParentEntity().belongsToTable() && entity.getState() == DatabaseObjectState.NEW && !entity.belongsToTable()) {
            this.getStoredParentEntity().getStoredParentDatabase().insertEntity(entity);
        }
    }

    private void setCastedEntity(E entity) {
        this.assertCanSetEntity(entity);
        this.updatePropbableBackReferencingFieldOfEntityForClear(entity);
        this.clear();
        this.updateStateForSetEntity(entity);
        this.updatePotentialBaseBackReferenceOfEntityForSetEntity(entity);
        this.insertEntityIntoDatabaseIfPossible(entity);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private void updateBackReferencingFieldForClear(IField backReferencingField) {
        switch (backReferencingField.getType()) {
            case BACK_REFERENCE: {
                BackReference backReference = (BackReference)backReferencingField;
                backReference.internalClear();
                break;
            }
            case OPTIONAL_BACK_REFERENCE: {
                OptionalBackReference optionalBackReference = (OptionalBackReference)backReferencingField;
                optionalBackReference.internalClear();
                break;
            }
        }
    }

    private void updatePotentialBaseBackReferenceOfEntityForSetEntity(E entity) {
        BASE_BACK_REFERENCE_UPDATER.ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(this, entity);
    }

    private void updateProbableBackReferencingFieldForClear() {
        if (this.containsAny()) {
            this.updateProbableBackReferencingFieldForClearWhenIsNotEmpty();
        }
    }

    private void updateProbableBackReferencingFieldForClearWhenIsNotEmpty() {
        Optional<? extends IField> backReferencingField = OPTIONAL_REFERENCE_TOOL.getOptionalStoredBackReferencingField(this);
        backReferencingField.ifPresent(this::updateBackReferencingFieldForClear);
    }

    private void updatePropbableBackReferencingFieldOfEntityForClear(E entity) {
        Optional<IField> pendantReferencingField = this.getOptionalPendantReferencingFieldToEntity(entity);
        if (pendantReferencingField.isPresent()) {
            OptionalReference reference = (OptionalReference)pendantReferencingField.get();
            reference.clear();
        }
    }

    private void updateStateForSetEntity(E entity) {
        this.referencedEntityId = entity.getId();
    }

    private void updateStateForClear() {
        this.referencedEntityId = null;
    }
}

