/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.fieldvalidator.ReferenceValidator;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.AbstractReference;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.BaseReferenceUpdater;
import ch.nolix.system.objectdata.model.Entity;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.modelexaminer.FieldExaminer;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.fieldvalidator.IReferenceValidator;
import ch.nolix.systemapi.objectdata.model.IAbstractBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IReference;
import ch.nolix.systemapi.objectdata.modelexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import java.util.Optional;

public final class Reference<E extends IEntity>
extends AbstractReference<E>
implements IReference<E> {
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private static final BaseReferenceUpdater BASE_BACK_REFERENCE_UPDATER = new BaseReferenceUpdater();
    private static final IReferenceValidator REFERENCE_VALIDATOR = new ReferenceValidator();
    private String referencedEntityId;

    private Reference(String referencedTableName) {
        super(referencedTableName);
    }

    public static <E2 extends Entity> Reference<E2> forEntity(Class<? extends E2> referencedEntityType) {
        String referencedTableName = referencedEntityType.getSimpleName();
        return new Reference(referencedTableName);
    }

    public static Reference<AbstractEntity> forTable(String referencedTableName) {
        return new Reference<AbstractEntity>(referencedTableName);
    }

    @Override
    public String getReferencedEntityId() {
        REFERENCE_VALIDATOR.assertIsNotEmpty(this);
        return this.referencedEntityId;
    }

    @Override
    public IContainer<IAbstractBackReference<IEntity>> getStoredAbstractBackReferencesThatReferencesBackThis() {
        if (this.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        IContainer<? extends IField> fields = this.getStoredReferencedEntity().internalGetStoredFields();
        Optional<IField> abstractBackReferenceContainer = fields.getOptionalStoredFirst(f -> f.referencesBackField(this));
        if (abstractBackReferenceContainer.isPresent()) {
            IAbstractBackReference abstractBackReference = (IAbstractBackReference)abstractBackReferenceContainer.get();
            return ImmutableList.withElement(abstractBackReference, new IAbstractBackReference[0]);
        }
        return ImmutableList.createEmpty();
    }

    @Override
    public E getStoredReferencedEntity() {
        return this.getStoredReferencedTable().getStoredEntityById(this.getReferencedEntityId());
    }

    @Override
    public ContentType getType() {
        return ContentType.REFERENCE;
    }

    @Override
    public IContainer<IField> internalGetStoredSubFields() {
        return ImmutableList.createEmpty();
    }

    @Override
    public void internalSetOptionalContent(Object content) {
        this.referencedEntityId = (String)content;
    }

    @Override
    public boolean isEmpty() {
        return this.referencedEntityId == null;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean referencesEntity(IEntity entity) {
        return this.containsAny() && entity != null && this.getReferencedEntityId().equals(entity.getId());
    }

    @Override
    public boolean referencesUninsertedEntity() {
        return this.containsAny() && !this.getStoredReferencedEntity().belongsToTable();
    }

    @Override
    public void setEntity(Object entity) {
        this.setCastedEntity((IEntity)entity);
    }

    @Override
    public void setEntityById(String id) {
        Object entity = this.getStoredReferencedTable().getStoredEntityById(id);
        this.setEntity(entity);
    }

    @Override
    protected void internalUpdateBackReferencingFieldsWhenIsInsertedIntoDatabase() {
        if (this.containsAny()) {
            this.updateProbableBackReferenceForSetOrAddedEntity(this.getStoredReferencedEntity());
        }
    }

    private void assertCanSetEntity(E entity) {
        REFERENCE_VALIDATOR.assertCanSetGivenEntity(this, (IEntity)entity);
    }

    private void clear() {
        if (this.containsAny()) {
            this.clearWhenContainsAny();
        }
    }

    private void clearWhenContainsAny() {
        this.updateProbableBackReferencingFieldForClear();
        this.updateStateForClear();
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private Optional<? extends IField> getOptionalPendantReferencingFieldToEntity(E entity) {
        return ENTITY_SEARCHER.getStoredFieldsThatAreBackReferencedFrom((IEntity)entity).getOptionalStoredFirst(rp -> rp.hasName(this.getName()));
    }

    private void insertEntityIntoDatabaseIfPossible(E entity) {
        if (this.belongsToEntity() && this.getStoredParentEntity().belongsToTable() && entity.getState() == DatabaseObjectState.NEW && !entity.belongsToTable()) {
            this.getStoredParentEntity().getStoredParentDatabase().insertEntity(entity);
        }
    }

    private void setCastedEntity(E entity) {
        this.assertCanSetEntity(entity);
        this.updatePropableBackReferencingFieldOfEntityForClear(entity);
        this.clear();
        this.updateStateForSetEntity(entity);
        this.updatePotentialBaseBackReferenceOfEntityForSetEntity(entity);
        this.insertEntityIntoDatabaseIfPossible(entity);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    private void updateBackReferencingFieldForClear(IField backReferencingField) {
        switch (backReferencingField.getType()) {
            case BACK_REFERENCE: {
                BackReference backReference = (BackReference)backReferencingField;
                backReference.internalClear();
                backReference.setAsEditedAndRunPotentialUpdateAction();
                break;
            }
            case OPTIONAL_BACK_REFERENCE: {
                OptionalBackReference optionalBackReference = (OptionalBackReference)backReferencingField;
                optionalBackReference.internalClear();
                optionalBackReference.setAsEditedAndRunPotentialUpdateAction();
                break;
            }
        }
    }

    private void updatePotentialBaseBackReferenceOfEntityForSetEntity(E entity) {
        BASE_BACK_REFERENCE_UPDATER.ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(this, entity);
    }

    private void updateProbableBackReferencingFieldForClear() {
        for (IAbstractBackReference iAbstractBackReference : this.getStoredAbstractBackReferencesThatReferencesBackThis()) {
            this.updateBackReferencingFieldForClear(iAbstractBackReference);
        }
    }

    private void updatePropableBackReferencingFieldOfEntityForClear(E entity) {
        for (IAbstractBackReference iAbstractBackReference : this.getStoredAbstractBackReferencesThatReferencesBackThis()) {
            Optional<IField> pendantReferencingField;
            if (!FIELD_EXAMINER.isForSingleContent(iAbstractBackReference) || !(pendantReferencingField = this.getOptionalPendantReferencingFieldToEntity(entity)).isPresent()) continue;
            Reference reference = (Reference)pendantReferencingField.get();
            reference.clear();
        }
    }

    private void updateStateForClear() {
        this.referencedEntityId = null;
    }

    private void updateStateForSetEntity(E entity) {
        this.referencedEntityId = entity.getId();
    }
}

