/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.datastructure.property.LazyCalculatedProperty;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.datatool.EntityCreator;
import ch.nolix.system.objectdata.datavalidator.TableValidator;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.Database;
import ch.nolix.system.objectdata.model.EntityLoader;
import ch.nolix.system.objectdata.modelexaminer.EntityExaminer;
import ch.nolix.system.objectdata.modelexaminer.TableExaminer;
import ch.nolix.system.objectdata.modelfiller.EntityFiller;
import ch.nolix.system.objectdata.modelsearcher.TableSearcher;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.middata.model.EntityLoadingDto;
import ch.nolix.systemapi.objectdata.datatool.IEntityCreator;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelexaminer.IEntityExaminer;
import ch.nolix.systemapi.objectdata.modelexaminer.ITableExaminer;
import ch.nolix.systemapi.objectdata.modelfiller.IEntityFiller;
import ch.nolix.systemapi.objectdata.modelsearcher.ITableSearcher;
import ch.nolix.systemapi.objectdata.schemaview.IColumnView;
import java.util.Optional;

public final class Table<E extends IEntity>
implements ITable<E> {
    private static final TableValidator TABLE_VALIDATOR = new TableValidator();
    private static final ITableSearcher TABLE_TOOL = new TableSearcher();
    private static final ITableExaminer TABLE_EXAMINER = new TableExaminer();
    private static final IEntityCreator ENTITY_CREATOR = new EntityCreator();
    private static final IEntityExaminer ENTITY_EXAMINER = new EntityExaminer();
    private static final IEntityFiller ENTITY_FILLER = new EntityFiller();
    private final Database parentDatabase;
    private final String name;
    private final String id;
    private final Class<E> entityClass;
    private final LazyCalculatedProperty<IContainer<IColumnView<ITable<IEntity>>>> columnsThatReferenceCurrentTable = LazyCalculatedProperty.forValueCreater(() -> TABLE_TOOL.getStoredColumsThatReferencesTable(this));
    private boolean loadedAllEntitiesInLocalData;
    private final LinkedList<IColumnView<ITable<IEntity>>> columnViews = LinkedList.createEmpty();
    private final LinkedList<E> entitiesInLocalData = LinkedList.createEmpty();

    private Table(Database parentDatabase, String name, String id, Class<E> entityClass) {
        Validator.assertThat(parentDatabase).thatIsNamed("parent Database").isNotNull();
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        Validator.assertThat(entityClass).thatIsNamed("entity class").isNotNull();
        this.parentDatabase = parentDatabase;
        this.name = name;
        this.id = id;
        this.entityClass = entityClass;
    }

    static <E2 extends IEntity> Table<E2> withParentDatabaseAndNameAndIdAndEntityType(Database parentDatabase, String name, String id, Class<E2> entityType) {
        return new Table<E2>(parentDatabase, name, id, entityType);
    }

    @Override
    public boolean containsEntityWithId(String id) {
        return this.getStoredMidDataDataAdapterAndSchemaReader().tableContainsEntity(this.getName(), id);
    }

    @Override
    public int getEntityCount() {
        return this.getStoredEntities().getCount();
    }

    @Override
    public Class<E> getEntityType() {
        return this.entityClass;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<E> getOptionalStoredEntityById(String id) {
        Optional<IEntity> entity = this.internalGetStoredEntitiesInLocalData().getOptionalStoredFirst(e -> e.hasId(id));
        if (entity.isEmpty()) {
            if (this.getStoredMidDataDataAdapterAndSchemaReader().tableContainsEntity(this.getName(), id)) {
                this.addEntityWithIdWhenIsNotAdded(id);
                return Optional.of(this.getStoredEntityByIdWhenIsInLocalData(id));
            }
            return Optional.empty();
        }
        return entity;
    }

    @Override
    public IContainer<IColumnView<ITable<IEntity>>> getStoredColumns() {
        return this.columnViews;
    }

    @Override
    public IContainer<E> getStoredEntities() {
        this.loadAllEntitiesInLocalDataIfNotLoaded();
        return this.entitiesInLocalData;
    }

    @Override
    public E getStoredEntityById(String id) {
        Optional<IEntity> entity = this.internalGetStoredEntitiesInLocalData().getOptionalStoredFirst(e -> e.hasId(id));
        if (entity.isEmpty()) {
            this.addEntityWithIdWhenIsNotAdded(id);
            return this.getStoredEntityByIdWhenIsInLocalData(id);
        }
        return (E)entity.get();
    }

    @Override
    public IDatabase getStoredParentDatabase() {
        return this.parentDatabase;
    }

    @Override
    public DatabaseObjectState getState() {
        if (this.parentDatabase.isClosed()) {
            return DatabaseObjectState.CLOSED;
        }
        if (this.internalGetStoredEntitiesInLocalData().containsAny(ENTITY_EXAMINER::isNewOrEditedOrDeleted)) {
            return DatabaseObjectState.EDITED;
        }
        return DatabaseObjectState.LOADED;
    }

    @Override
    public ITable<E> insertEntity(E entity) {
        entity.internalSetParentTable(this);
        TABLE_VALIDATOR.assertCanInsertEntity(this, (IEntity)entity);
        this.insertWhenCanBeInserted(entity);
        return this;
    }

    @Override
    public boolean isClosed() {
        return this.parentDatabase.isClosed();
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public boolean isEdited() {
        return this.getState() == DatabaseObjectState.EDITED;
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.parentDatabase.isConnectedWithRealDatabase();
    }

    @Override
    public boolean isLoaded() {
        return this.getState() == DatabaseObjectState.LOADED;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public IContainer<E> internalGetStoredEntitiesInLocalData() {
        return this.entitiesInLocalData;
    }

    void close() {
        for (IEntity e : this.internalGetStoredEntitiesInLocalData()) {
            ((AbstractEntity)e).close();
        }
    }

    IDataAdapterAndSchemaReader getStoredMidDataDataAdapterAndSchemaReader() {
        return this.parentDatabase.getStoredMidDataAdapterAndSchemaReader();
    }

    void internalAddColumn(IColumnView<ITable<IEntity>> columnView) {
        this.columnViews.addAtEnd(columnView);
    }

    IContainer<IColumnView<ITable<IEntity>>> internalGetColumnsThatReferencesCurrentTable() {
        return this.columnsThatReferenceCurrentTable.getStoredValue();
    }

    void internalSetColumns(IContainer<IColumnView<ITable<IEntity>>> columnViews) {
        this.columnViews.clear();
        this.columnViews.addAtEnd(columnViews);
    }

    private void addEntityWithIdWhenIsNotAdded(String id) {
        Object entity = EntityLoader.loadEntityById(this, id, this.getStoredMidDataDataAdapterAndSchemaReader());
        this.entitiesInLocalData.addAtEnd(entity);
    }

    private E getStoredEntityByIdWhenIsInLocalData(String id) {
        return (E)this.internalGetStoredEntitiesInLocalData().getStoredFirst(e -> e.hasId(id));
    }

    private void insertEntityFromGivenLoadedEntityDtoInLocalDataIfNotInserted(EntityLoadingDto loadedEntity) {
        if (!TABLE_EXAMINER.containsEntityWithGivenIdInLocalData(this, loadedEntity.id())) {
            Object entity = ENTITY_CREATOR.createEmptyEntityForTable(this);
            entity.internalSetParentTable(this);
            ENTITY_FILLER.fillUpEntityFromEntityLoadingDto((IEntity)entity, loadedEntity);
            this.entitiesInLocalData.addAtEnd(entity);
        }
    }

    private void insertWhenCanBeInserted(E entity) {
        this.entitiesInLocalData.addAtEnd(entity);
        ((AbstractEntity)entity).noteInsertIntoDatabase();
    }

    private void loadAllEntitiesInLocalDataIfNotLoaded() {
        if (!this.loadedAllEntitiesInLocalData()) {
            this.loadAllEntitiesInLocalDataWhenNotLoadedAll();
        }
    }

    private void loadAllEntitiesInLocalDataWhenNotLoadedAll() {
        for (EntityLoadingDto r : this.getStoredMidDataDataAdapterAndSchemaReader().loadEntities(this.getName())) {
            this.insertEntityFromGivenLoadedEntityDtoInLocalDataIfNotInserted(r);
        }
        this.loadedAllEntitiesInLocalData = true;
    }

    private boolean loadedAllEntitiesInLocalData() {
        return this.loadedAllEntitiesInLocalData;
    }
}

