/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.datamodel.fliedvalue.ValueMapper;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.coreapi.datamodel.fieldvalue.IValueMapper;
import ch.nolix.system.objectdata.fieldtool.ValueFieldTool;
import ch.nolix.system.objectdata.fieldvalidator.ValueValidator;
import ch.nolix.system.objectdata.model.AbstractValueField;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.fieldtool.IValueFieldTool;
import ch.nolix.systemapi.objectdata.fieldvalidator.IValueValidator;
import ch.nolix.systemapi.objectdata.model.IValueField;

public final class ValueField<V>
extends AbstractValueField<V>
implements IValueField<V> {
    private static final IValueFieldTool VALUE_TOOL = new ValueFieldTool();
    private static final IValueValidator VALUE_VALIDATOR = new ValueValidator();
    private static final IValueMapper VALUE_MAPPER = new ValueMapper();
    private V internalValue;

    private ValueField(Class<V> valueType) {
        super(valueType);
    }

    public static <V2> ValueField<V2> withInitialValue(V2 initialValue) {
        ValueField<?> value = ValueField.withValueType(initialValue.getClass());
        value.setValue(initialValue);
        return value;
    }

    public static <V2> ValueField<V2> withValueType(Class<V2> valueType) {
        return new ValueField<V2>(valueType);
    }

    @Override
    public V getStoredValue() {
        VALUE_VALIDATOR.assertIsNotEmpty(this);
        return this.internalValue;
    }

    @Override
    public ContentType getType() {
        return ContentType.VALUE;
    }

    @Override
    public void internalSetOptionalContent(Object content) {
        this.internalValue = content;
    }

    @Override
    public boolean isEmpty() {
        return this.internalValue == null;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public void setValue(V value) {
        VALUE_VALIDATOR.assertCanSetGivenValue(this, value);
        this.updateStateForSetValue(value);
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    @Override
    public void setValueFromString(String string) {
        DataType dataType = DataType.forType(VALUE_TOOL.getDataType(this));
        Object value = VALUE_MAPPER.mapStringToValue(string, dataType);
        this.setValue(value);
    }

    private void updateStateForSetValue(V value) {
        this.internalValue = value;
    }
}

