/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.modelexaminer;

import ch.nolix.coreapi.attribute.mandatoryattribute.IIdHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.modelexaminer.FieldExaminer;
import ch.nolix.systemapi.databaseobject.databaseobjectrequest.DeletionRequestable;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelexaminer.IEntityExaminer;
import ch.nolix.systemapi.objectdata.modelexaminer.IFieldExaminer;

public final class EntityExaminer
extends DatabaseObjectExaminer
implements IEntityExaminer {
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();

    @Override
    public boolean allNewAndEditedMandatoryFieldsAreSet(IEntity entity) {
        if (this.isNewOrEdited(entity)) {
            return entity.internalGetStoredFields().containsOnly(FIELD_EXAMINER::isSetForCaseWhenIsMandatoryAndNewOrEdited);
        }
        return true;
    }

    @Override
    public boolean canBeDeleted(IEntity entity) {
        return entity != null && entity.isLoaded() && !this.isReferencedIgnoringLocallyDeletedEntities(entity);
    }

    @Override
    public boolean canBeInsertedIntoTable(IEntity entity) {
        return entity != null && entity.isNew() && entity.belongsToTable();
    }

    @Override
    public boolean isReferenced(IEntity entity) {
        return this.isReferencedInLocalData(entity) || entity.isReferencedInPersistedData();
    }

    @Override
    public boolean isReferencedIgnoringLocallyDeletedEntities(IEntity entity) {
        return this.isReferencedInLocalData(entity) || this.isReferencedInPersistedDataIgnoringLocallyDeletedEntities(entity);
    }

    @Override
    public boolean isReferencedInLocalData(IEntity entity) {
        if (!entity.belongsToTable()) {
            return false;
        }
        for (ITable iTable : ((ITable)entity.getStoredParentTable()).getStoredParentDatabase().getStoredTables()) {
            if (!iTable.internalGetStoredEntitiesInLocalData().containsAny(e -> this.referencesGivenEntity((IEntity)e, entity))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean referencesGivenEntity(IEntity sourceEntity, IEntity entity) {
        return sourceEntity.internalGetStoredFields().containsAny(p -> p.referencesEntity(entity));
    }

    private IContainer<String> getLocallyDeletedEntities(IEntity entity) {
        return ((ITable)entity.getStoredParentTable()).getStoredParentDatabase().getStoredTables().toMultiples(ITable::internalGetStoredEntitiesInLocalData).getStoredSelected(DeletionRequestable::isDeleted).to(IIdHolder::getId);
    }

    private boolean isReferencedInPersistedDataIgnoringLocallyDeletedEntities(IEntity entity) {
        if (entity.isReferencedInPersistedData()) {
            IContainer<String> locallyDeletedEntities = this.getLocallyDeletedEntities(entity);
            return entity.isReferencedInPersistedDataIgnoringGivenEntities(locallyDeletedEntities);
        }
        return false;
    }
}

