/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.modelexaminer;

import ch.nolix.coreapi.datamodel.cardinality.BaseCardinality;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.systemapi.objectdata.model.IAbstractBackReference;
import ch.nolix.systemapi.objectdata.model.IAbstractReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.modelexaminer.IFieldExaminer;

public final class FieldExaminer
extends DatabaseObjectExaminer
implements IFieldExaminer {
    @Override
    public boolean belongsToEntity(IField field) {
        return field != null && field.belongsToEntity();
    }

    @Override
    public boolean belongsToLoadedEntity(IField field) {
        return this.belongsToEntity(field) && ((IEntity)field.getStoredParentEntity()).isLoaded();
    }

    @Override
    public boolean canReferenceBackAbstractReference(IField field, IAbstractReference<? extends IEntity> abstractReference) {
        if (field instanceof IAbstractBackReference && abstractReference != null) {
            IAbstractBackReference abstractBackReference = (IAbstractBackReference)field;
            return this.abstractBackReferenceCanReferenceBackAbstractReferenceWhenParametersAreNotNull(abstractBackReference, abstractReference);
        }
        return false;
    }

    private boolean abstractBackReferenceCanReferenceBackAbstractReferenceWhenParametersAreNotNull(IAbstractBackReference<IEntity> abstractBackReference, IAbstractReference<? extends IEntity> abstractReference) {
        if (abstractReference.belongsToEntity()) {
            String backReferencedTableName = abstractBackReference.getBackReferencedTableName();
            String backReferencedFieldName = abstractBackReference.getBackReferencedFieldName();
            return backReferencedTableName.equals(((IEntity)abstractReference.getStoredParentEntity()).getParentTableName()) && backReferencedFieldName.equals(abstractReference.getName());
        }
        return false;
    }

    @Override
    public boolean isForMultiContent(IField field) {
        return field != null && field.getType().getCardinality().getBaseCardinality() == BaseCardinality.MULTI;
    }

    @Override
    public boolean isForSingleContent(IField field) {
        return field != null && field.getType().getCardinality().getBaseCardinality() == BaseCardinality.SINGLE;
    }

    @Override
    public boolean isMandatoryButEmpty(IField field) {
        return field != null && field.isMandatory() && field.isEmpty();
    }

    @Override
    public boolean isSetForCaseWhenIsMandatoryAndNewOrEdited(IField field) {
        return field != null && (!field.isMandatory() || !this.isNewOrEdited(field) || field.containsAny());
    }
}

