/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.modelmapper;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.schemaview.BackReferenceModelView;
import ch.nolix.system.objectdata.schemaview.MultiBackReferenceModelView;
import ch.nolix.system.objectdata.schemaview.MultiReferenceModelView;
import ch.nolix.system.objectdata.schemaview.MultiValueModelView;
import ch.nolix.system.objectdata.schemaview.OptionalBackReferenceModelView;
import ch.nolix.system.objectdata.schemaview.OptionalReferenceModelView;
import ch.nolix.system.objectdata.schemaview.OptionalValueModelView;
import ch.nolix.system.objectdata.schemaview.ReferenceModelView;
import ch.nolix.system.objectdata.schemaview.ValueModelView;
import ch.nolix.systemapi.midschema.model.BackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.midschema.model.MultiBackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.MultiReferenceModelDto;
import ch.nolix.systemapi.midschema.model.MultiValueModelDto;
import ch.nolix.systemapi.midschema.model.OptionalBackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.OptionalReferenceModelDto;
import ch.nolix.systemapi.midschema.model.OptionalValueModelDto;
import ch.nolix.systemapi.midschema.model.ReferenceModelDto;
import ch.nolix.systemapi.midschema.model.ValueModelDto;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.schemaview.IColumnView;
import ch.nolix.systemapi.objectdata.schemaview.IContentModelView;

public final class ContentModelMapper {
    public IContentModelView<ITable<IEntity>> mapContentModelDtoToContentModel(IContentModelDto contentModelDto, IContainer<? extends ITable<IEntity>> referencableTables) {
        if (contentModelDto instanceof ValueModelDto) {
            Class<?> valueType = contentModelDto.getDataType().getDataTypeClass();
            return ValueModelView.forValueType(valueType);
        }
        if (contentModelDto instanceof OptionalValueModelDto) {
            Class<?> valueType = contentModelDto.getDataType().getDataTypeClass();
            return OptionalValueModelView.forValueType(valueType);
        }
        if (contentModelDto instanceof MultiValueModelDto) {
            Class<?> valueType = contentModelDto.getDataType().getDataTypeClass();
            return MultiValueModelView.forValueType(valueType);
        }
        if (contentModelDto instanceof ReferenceModelDto) {
            ReferenceModelDto referenceModelDto = (ReferenceModelDto)contentModelDto;
            String tableId = referenceModelDto.referencedTableId();
            ITable table = referencableTables.getStoredFirst(t -> t.hasId(tableId));
            return ReferenceModelView.forReferencedTable(table);
        }
        if (contentModelDto instanceof OptionalReferenceModelDto) {
            OptionalReferenceModelDto optionalReferenceModelDto = (OptionalReferenceModelDto)contentModelDto;
            String tableId = optionalReferenceModelDto.referencedTableId();
            ITable table = referencableTables.getStoredFirst(t -> t.hasId(tableId));
            return OptionalReferenceModelView.forReferencedTable(table);
        }
        if (contentModelDto instanceof MultiReferenceModelDto) {
            MultiReferenceModelDto multiReferenceModelDto = (MultiReferenceModelDto)contentModelDto;
            String tableId = multiReferenceModelDto.referencedTableId();
            ITable table = referencableTables.getStoredFirst(t -> t.hasId(tableId));
            return MultiReferenceModelView.forReferencedTable(table);
        }
        if (contentModelDto instanceof BackReferenceModelDto) {
            BackReferenceModelDto backReferenceModelDto = (BackReferenceModelDto)contentModelDto;
            String backReferencedColumnId = backReferenceModelDto.backReferencedColumnId();
            IContainer referencableColumns = referencableTables.toMultiples(ITable::getStoredColumns);
            IColumnView backReferencedColumn = referencableColumns.getStoredFirst(c -> c.hasId(backReferencedColumnId));
            return BackReferenceModelView.forBackReferencedColumn(backReferencedColumn);
        }
        if (contentModelDto instanceof OptionalBackReferenceModelDto) {
            OptionalBackReferenceModelDto optionalBackReferenceModelDto = (OptionalBackReferenceModelDto)contentModelDto;
            String backReferencedColumnId = optionalBackReferenceModelDto.backReferencedColumnId();
            IContainer referencableColumns = referencableTables.toMultiples(ITable::getStoredColumns);
            IColumnView backReferencedColumn = referencableColumns.getStoredFirst(c -> c.hasId(backReferencedColumnId));
            return OptionalBackReferenceModelView.forBackReferencedColumn(backReferencedColumn);
        }
        if (contentModelDto instanceof MultiBackReferenceModelDto) {
            MultiBackReferenceModelDto multiBackReferenceModelDto = (MultiBackReferenceModelDto)contentModelDto;
            String backReferencedColumnId = multiBackReferenceModelDto.backReferencedColumnId();
            IContainer referencableColumns = referencableTables.toMultiples(ITable::getStoredColumns);
            IColumnView backReferencedColumn = referencableColumns.getStoredFirst(c -> c.hasId(backReferencedColumnId));
            return MultiBackReferenceModelView.forBackReferencedColumn(backReferencedColumn);
        }
        throw InvalidArgumentException.forArgument(contentModelDto);
    }
}

