/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.modelsearcher;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.modelexaminer.FieldExaminer;
import ch.nolix.systemapi.databaseobject.databaseobjectrequest.EditingRequestable;
import ch.nolix.systemapi.objectdata.model.IAbstractBackReference;
import ch.nolix.systemapi.objectdata.model.IAbstractReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.modelexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import java.util.Optional;

public final class EntitySearcher
implements IEntitySearcher {
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();

    @Override
    public Optional<IAbstractBackReference<IEntity>> getOptionalStoredAbstractBackReferenceThatCanBackReferenceAbstractReference(IEntity entity, IAbstractReference<? extends IEntity> baseReference) {
        if (entity != null && baseReference != null) {
            IContainer<? extends IField> fields = entity.internalGetStoredFields();
            for (IField iField : fields) {
                if (!FIELD_EXAMINER.canReferenceBackAbstractReference(iField, baseReference)) continue;
                return Optional.of((IAbstractBackReference)iField);
            }
        }
        return Optional.empty();
    }

    @Override
    public IContainer<IAbstractBackReference<IEntity>> getStoredAbstractBackReferencesThatReferencesBackEntity(IEntity entity) {
        if (entity == null) {
            return ImmutableList.createEmpty();
        }
        IContainer<? extends IField> fields = entity.internalGetStoredFields();
        return fields.toMultiples(IField::getStoredAbstractBackReferencesThatReferencesBackThis);
    }

    @Override
    public IContainer<? extends IField> getStoredEditedFields(IEntity entity) {
        return entity.internalGetStoredFields().getStoredSelected(EditingRequestable::isEdited);
    }

    @Override
    public IField getStoredFieldByName(IEntity entity, String name) {
        IContainer<? extends IField> fields = entity.internalGetStoredFields();
        return fields.getStoredFirst(f -> f.hasName(name));
    }

    @Override
    public IContainer<IAbstractReference<IEntity>> getStoredFieldsThatAreBackReferencedFrom(IEntity entity) {
        if (entity == null) {
            return ImmutableList.createEmpty();
        }
        IContainer<? extends IField> fields = entity.internalGetStoredFields();
        return fields.toMultiples(IField::getStoredAbstractReferencesThatAreBackReferencedFromThis);
    }
}

