/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.midschemamodelmapper;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.systemapi.midschema.model.BackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.midschema.model.MultiBackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.MultiReferenceModelDto;
import ch.nolix.systemapi.midschema.model.MultiValueModelDto;
import ch.nolix.systemapi.midschema.model.OptionalBackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.OptionalReferenceModelDto;
import ch.nolix.systemapi.midschema.model.OptionalValueModelDto;
import ch.nolix.systemapi.midschema.model.ReferenceModelDto;
import ch.nolix.systemapi.midschema.model.ValueModelDto;
import ch.nolix.systemapi.objectschema.midschemamodelmapper.IContentModelDtoMapper;
import ch.nolix.systemapi.objectschema.model.IBackReferenceModel;
import ch.nolix.systemapi.objectschema.model.IContentModel;
import ch.nolix.systemapi.objectschema.model.IMultiBackReferenceModel;
import ch.nolix.systemapi.objectschema.model.IMultiReferenceModel;
import ch.nolix.systemapi.objectschema.model.IMultiValueModel;
import ch.nolix.systemapi.objectschema.model.IOptionalBackReferenceModel;
import ch.nolix.systemapi.objectschema.model.IOptionalReferenceModel;
import ch.nolix.systemapi.objectschema.model.IOptionalValueModel;
import ch.nolix.systemapi.objectschema.model.IReferenceModel;
import ch.nolix.systemapi.objectschema.model.IValueModel;

public final class ContentModelDtoMapper
implements IContentModelDtoMapper {
    @Override
    public IContentModelDto mapContentModelToContentModelDto(IContentModel contentModel) {
        if (contentModel instanceof IValueModel) {
            IValueModel valueModel = (IValueModel)contentModel;
            return new ValueModelDto(valueModel.getDataType());
        }
        if (contentModel instanceof IOptionalValueModel) {
            IOptionalValueModel optionalValueModel = (IOptionalValueModel)contentModel;
            return new OptionalValueModelDto(optionalValueModel.getDataType());
        }
        if (contentModel instanceof IMultiValueModel) {
            IMultiValueModel multiValueModel = (IMultiValueModel)contentModel;
            return new MultiValueModelDto(multiValueModel.getDataType());
        }
        if (contentModel instanceof IReferenceModel) {
            IReferenceModel referenceModel = (IReferenceModel)contentModel;
            DataType dataType = referenceModel.getDataType();
            String referencedTableId = referenceModel.getReferencedTable().getId();
            return new ReferenceModelDto(dataType, referencedTableId);
        }
        if (contentModel instanceof IOptionalReferenceModel) {
            IOptionalReferenceModel optionalReferenceModel = (IOptionalReferenceModel)contentModel;
            DataType dataType = optionalReferenceModel.getDataType();
            String referencedTableId = optionalReferenceModel.getReferencedTable().getId();
            return new OptionalReferenceModelDto(dataType, referencedTableId);
        }
        if (contentModel instanceof IMultiReferenceModel) {
            IMultiReferenceModel multiReferenceModel = (IMultiReferenceModel)contentModel;
            DataType dataType = multiReferenceModel.getDataType();
            String referencedTableId = multiReferenceModel.getReferencedTable().getId();
            return new MultiReferenceModelDto(dataType, referencedTableId);
        }
        if (contentModel instanceof IBackReferenceModel) {
            IBackReferenceModel backReferenceModel = (IBackReferenceModel)contentModel;
            DataType dataType = backReferenceModel.getDataType();
            String backReferencedColumnId = backReferenceModel.getBackReferencedColumn().getId();
            return new BackReferenceModelDto(dataType, backReferencedColumnId);
        }
        if (contentModel instanceof IOptionalBackReferenceModel) {
            IOptionalBackReferenceModel optionalBackReferenceModel = (IOptionalBackReferenceModel)contentModel;
            DataType dataType = optionalBackReferenceModel.getDataType();
            String backReferencedColumnId = optionalBackReferenceModel.getBackReferencedColumn().getId();
            return new OptionalBackReferenceModelDto(dataType, backReferencedColumnId);
        }
        if (contentModel instanceof IMultiBackReferenceModel) {
            IMultiBackReferenceModel multiBackReferenceModel = (IMultiBackReferenceModel)contentModel;
            DataType dataType = multiBackReferenceModel.getDataType();
            String backReferencedColumnId = multiBackReferenceModel.getBackReferencedColumn().getId();
            return new MultiBackReferenceModelDto(dataType, backReferencedColumnId);
        }
        throw InvalidArgumentException.forArgument(contentModel);
    }
}

