/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.systemapi.objectschema.model.IAbstractReferenceModel;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.ITable;

public abstract class AbstractReferenceModel
implements IAbstractReferenceModel {
    private static final DataType DATA_TYPE = DataType.STRING;
    private final ITable referencedTable;

    protected AbstractReferenceModel(ITable referencedTable) {
        Validator.assertThat(referencedTable).thatIsNamed("referenced table").isNotNull();
        this.referencedTable = referencedTable;
    }

    @Override
    public final DataType getDataType() {
        return DATA_TYPE;
    }

    @Override
    public final ITable getReferencedTable() {
        return this.referencedTable;
    }

    @Override
    public final boolean referencesTable(ITable table) {
        return this.getReferencedTable() == table;
    }

    @Override
    public final boolean referencesBackColumn(IColumn column) {
        return false;
    }
}

