/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.core.errorcontrol.invalidargumentexception.ClosedArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.DeletedArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NewArgumentException;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.databaseobject.model.IDatabaseObject;

abstract class AbstractSchemaObject
implements IDatabaseObject {
    private DatabaseObjectState state = DatabaseObjectState.NEW;

    AbstractSchemaObject() {
    }

    @Override
    public final DatabaseObjectState getState() {
        return this.state;
    }

    @Override
    public final boolean isClosed() {
        return this.getState() == DatabaseObjectState.CLOSED;
    }

    @Override
    public final boolean isDeleted() {
        return this.getState() == DatabaseObjectState.DELETED;
    }

    @Override
    public final boolean isEdited() {
        return this.getState() == DatabaseObjectState.EDITED;
    }

    @Override
    public final boolean isLoaded() {
        return this.getState() == DatabaseObjectState.LOADED;
    }

    @Override
    public final boolean isNew() {
        return this.getState() == DatabaseObjectState.NEW;
    }

    protected abstract void noteClose();

    final void close() {
        this.state = DatabaseObjectState.CLOSED;
        this.noteClose();
    }

    final void setDeleted() {
        switch (this.getState()) {
            case NEW: {
                throw NewArgumentException.forArgument(this);
            }
            case LOADED: 
            case EDITED: {
                break;
            }
            case DELETED: {
                throw DeletedArgumentException.forArgument(this);
            }
            case CLOSED: {
                throw ClosedArgumentException.forArgument(this);
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)this.getState());
            }
        }
        this.state = DatabaseObjectState.DELETED;
    }

    final void setEdited() {
        switch (this.getState()) {
            case NEW: {
                break;
            }
            case LOADED: {
                this.state = DatabaseObjectState.EDITED;
                break;
            }
            case EDITED: {
                break;
            }
            case DELETED: {
                throw DeletedArgumentException.forArgument(this);
            }
            case CLOSED: {
                throw ClosedArgumentException.forArgument(this);
            }
        }
    }

    final void setLoaded() {
        switch (this.getState()) {
            case NEW: {
                break;
            }
            case LOADED: {
                throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is already loaded");
            }
            case EDITED: {
                throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is already edited");
            }
            case DELETED: {
                throw DeletedArgumentException.forArgument(this);
            }
            case CLOSED: {
                throw ClosedArgumentException.forArgument(this);
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        this.state = DatabaseObjectState.LOADED;
    }
}

