/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectschema.model.Column;
import ch.nolix.system.objectschema.model.ContentModelMapper;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.objectschema.model.IContentModel;

public final class ColumnMapper {
    private ColumnMapper() {
    }

    public static IContainer<Column> mapMidSchemaTableDtoToLoadedColumns(TableDto midTableDto, IContainer<Table> tables) {
        String tableName = midTableDto.name();
        Table table = tables.getStoredFirst(t -> t.hasName(tableName));
        IContainer<ColumnDto> midColumns = midTableDto.columns();
        return midColumns.to(c -> ColumnMapper.mapMidSchemaColumnDtoToLoadedColumn(table, c, tables));
    }

    private static Column mapMidSchemaColumnDtoToLoadedColumn(Table parentTable, ColumnDto midColumnDto, IContainer<Table> tables) {
        String id = midColumnDto.id();
        String name = midColumnDto.name();
        IContentModelDto midContentModel = midColumnDto.contentModel();
        IContentModel contentModel = ContentModelMapper.mapMidSchemaContentModelDtoToContentModel(midContentModel, tables);
        Column column = Column.withIdAndNameAndContentModel(id, name, contentModel);
        column.setLoaded();
        column.setParentTableAttribute(parentTable);
        return column;
    }
}

