/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.system.objectschema.model.BackReferenceModel;
import ch.nolix.system.objectschema.model.MultiBackReferenceModel;
import ch.nolix.system.objectschema.model.MultiReferenceModel;
import ch.nolix.system.objectschema.model.OptionalBackReferenceModel;
import ch.nolix.system.objectschema.model.OptionalReferenceModel;
import ch.nolix.system.objectschema.model.ReferenceModel;
import ch.nolix.system.objectschema.model.ValueModel;
import ch.nolix.systemapi.midschema.model.BackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.midschema.model.MultiBackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.MultiReferenceModelDto;
import ch.nolix.systemapi.midschema.model.MultiValueModelDto;
import ch.nolix.systemapi.midschema.model.OptionalBackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.OptionalReferenceModelDto;
import ch.nolix.systemapi.midschema.model.OptionalValueModelDto;
import ch.nolix.systemapi.midschema.model.ReferenceModelDto;
import ch.nolix.systemapi.midschema.model.ValueModelDto;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IContentModel;
import ch.nolix.systemapi.objectschema.model.ITable;

public final class ContentModelMapper {
    private ContentModelMapper() {
    }

    /*
     * Loose catch block
     */
    public static IContentModel mapMidSchemaContentModelDtoToContentModel(IContentModelDto midContentModelDto, IContainer<? extends ITable> tables) {
        if (midContentModelDto instanceof ValueModelDto) {
            DataType dataType = ((ValueModelDto)midContentModelDto).dataType();
            return ValueModel.forDataType(dataType);
        }
        if (midContentModelDto instanceof OptionalValueModelDto) {
            DataType dataType = ((OptionalValueModelDto)midContentModelDto).dataType();
            return ValueModel.forDataType(dataType);
        }
        if (midContentModelDto instanceof MultiValueModelDto) {
            DataType dataType = ((MultiValueModelDto)midContentModelDto).dataType();
            return ValueModel.forDataType(dataType);
        }
        if (midContentModelDto instanceof ReferenceModelDto) {
            ReferenceModelDto referenceModelDto = (ReferenceModelDto)midContentModelDto;
            String referencedTableId = referenceModelDto.referencedTableId();
            ITable referencedTable = tables.getStoredFirst(t -> t.hasId(referencedTableId));
            return ReferenceModel.forReferencedTable(referencedTable);
        }
        if (midContentModelDto instanceof OptionalReferenceModelDto) {
            OptionalReferenceModelDto optionalReferenceModelDto = (OptionalReferenceModelDto)midContentModelDto;
            String referencedTableId = optionalReferenceModelDto.referencedTableId();
            ITable referencedTable = tables.getStoredFirst(t -> t.hasId(referencedTableId));
            return OptionalReferenceModel.forReferencedTable(referencedTable);
        }
        if (midContentModelDto instanceof MultiReferenceModelDto) {
            MultiReferenceModelDto multiBackReferenceModelDto = (MultiReferenceModelDto)midContentModelDto;
            String referencedTableId = multiBackReferenceModelDto.referencedTableId();
            ITable referencedTable = tables.getStoredFirst(t -> t.hasId(referencedTableId));
            return MultiReferenceModel.forReferencedTable(referencedTable);
        }
        if (midContentModelDto instanceof BackReferenceModelDto) {
            BackReferenceModelDto backReferenceModelDto = (BackReferenceModelDto)midContentModelDto;
            String backReferenceColumnId = backReferenceModelDto.backReferencedColumnId();
            IContainer columns = tables.toMultiples(ITable::getStoredColumns);
            IColumn backReferencedColumn = columns.getStoredFirst(c -> c.hasId(backReferenceColumnId));
            return BackReferenceModel.forBackReferencedColumn(backReferencedColumn);
        }
        if (midContentModelDto instanceof OptionalBackReferenceModelDto) {
            OptionalBackReferenceModelDto optionalBackReferenceModelDto = (OptionalBackReferenceModelDto)midContentModelDto;
            String backReferencedColumnId = optionalBackReferenceModelDto.backReferencedColumnId();
            IContainer columns = tables.toMultiples(ITable::getStoredColumns);
            IColumn backReferencedColumn = columns.getStoredFirst(c -> c.hasId(backReferencedColumnId));
            return OptionalBackReferenceModel.forBackReferencedColumn(backReferencedColumn);
        }
        if (midContentModelDto instanceof MultiBackReferenceModelDto) {
            MultiBackReferenceModelDto multiBackReferenceModelDto = (MultiBackReferenceModelDto)midContentModelDto;
            String backReferencedColumnId = multiBackReferenceModelDto.backReferencedColumnId();
            IContainer columns = tables.toMultiples(ITable::getStoredColumns);
            IColumn backReferencedColumn = columns.getStoredFirst(c -> c.hasId(backReferencedColumnId));
            return MultiBackReferenceModel.forBackReferencedColumn(backReferencedColumn);
        }
        throw InvalidArgumentException.forArgument(midContentModelDto);
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

