/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.datamodel.id.IdCreator;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotBelongToParentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.objectschema.model.AbstractSchemaObject;
import ch.nolix.system.objectschema.model.Column;
import ch.nolix.system.objectschema.model.Database;
import ch.nolix.system.objectschema.model.TableEditor;
import ch.nolix.system.objectschema.modelmutationvalidator.TableMutationValidator;
import ch.nolix.system.objectschema.modelvalidator.TableValidator;
import ch.nolix.systemapi.midschema.adapter.ISchemaAdapter;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IContentModel;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modelmutationvalidator.ITableMutationValidator;
import ch.nolix.systemapi.objectschema.modelvalidator.ITableValidator;

public final class Table
extends AbstractSchemaObject
implements ITable {
    private static final ITableMutationValidator MUTATION_VALIDATOR = new TableMutationValidator();
    private static final ITableValidator TABLE_VALIDATOR = new TableValidator();
    private final String id;
    private String name;
    private Database parentDatabase;
    private ILinkedList<Column> columns = LinkedList.createEmpty();

    private Table(String id, String name) {
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        this.id = id;
        this.setName(name);
    }

    public static Table withIdAndName(String id, String name) {
        return new Table(id, name);
    }

    public static Table withName(String name) {
        String id = IdCreator.createIdOf10HexadecimalCharacters();
        return new Table(id, name);
    }

    @Override
    public Table addColumn(IColumn column) {
        MUTATION_VALIDATOR.assertCanAddColumnToTable(this, column);
        TableEditor.addColumnToTable(this, (Column)column);
        return this;
    }

    @Override
    public ITable addColumns(IContainer<IColumn> columns) {
        for (IColumn c : columns) {
            this.addColumn(c);
        }
        return this;
    }

    @Override
    public boolean belongsToDatabase() {
        return this.parentDatabase != null;
    }

    @Override
    public Table addColumnWithNameAndContentModel(String name, IContentModel contentModel) {
        return this.addColumn(new Column(name, contentModel));
    }

    @Override
    public void delete() {
        MUTATION_VALIDATOR.assertCanDeleteTable(this);
        TableEditor.deleteTable(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Database getStoredParentDatabase() {
        this.assertBelongsToDatabase();
        return this.parentDatabase;
    }

    @Override
    public IContainer<? extends IColumn> getStoredColumns() {
        return this.columns;
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return this.belongsToDatabase() && this.getStoredParentDatabase().isConnectedWithRealDatabase();
    }

    @Override
    public Table setName(String name) {
        MUTATION_VALIDATOR.assertCanSetNameToTable(this, name);
        TableEditor.setNameToTable(this, name);
        return this;
    }

    @Override
    protected void noteClose() {
        for (Column c : this.columns) {
            c.close();
        }
    }

    void addColumnAttribute(Column column) {
        this.columns.addAtEnd(column);
    }

    ISchemaAdapter getStoredMidSchemaAdapter() {
        return this.getStoredParentDatabase().getStoredMidSchemaAdapter();
    }

    void removeColumnAttribute(Column column) {
        this.columns.removeStrictlyFirstOccurrenceOf(column);
    }

    void setNameAttribute(String name) {
        this.name = name;
    }

    void setParentDatabase(Database parentDatabase) {
        Validator.assertThat(parentDatabase).thatIsNamed("parent database").isNotNull();
        TABLE_VALIDATOR.assertDoesNotBelongToDatabase(this);
        this.parentDatabase = parentDatabase;
    }

    private void assertBelongsToDatabase() {
        if (!this.belongsToDatabase()) {
            throw ArgumentDoesNotBelongToParentException.forArgumentAndParentType(this, Database.class);
        }
    }
}

