/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.modelmutationvalidator;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectschema.modelmutationexaminer.ColumnMutationExaminer;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IContentModel;
import ch.nolix.systemapi.objectschema.modelmutationexaminer.IColumnMutationExaminer;
import ch.nolix.systemapi.objectschema.modelmutationvalidator.IColumnMutationValidator;

public final class ColumnMutationValidator
implements IColumnMutationValidator {
    private static final IColumnMutationExaminer COLUMN_MUTATION_EXAMINER = new ColumnMutationExaminer();

    @Override
    public void assertCanBeDeleted(IColumn column) {
        if (!COLUMN_MUTATION_EXAMINER.canBeDeleted(column)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(column, "cannot be deleted");
        }
    }

    @Override
    public void assertCanSetName(IColumn column, String name) {
        if (!COLUMN_MUTATION_EXAMINER.canSetName(column, name)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(column, "cannot set the name '" + name + "'");
        }
    }

    @Override
    public void assertCanSetContentModel(IColumn column, IContentModel contentModel) {
        if (!COLUMN_MUTATION_EXAMINER.canSetContentModel(column, contentModel)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(contentModel, "cannot set the content model '" + String.valueOf(contentModel) + "'");
        }
    }
}

