/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.schematool;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentBelongsToParentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotBelongToParentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectschema.modelexaminer.ContentModelExaminer;
import ch.nolix.systemapi.midschema.fieldproperty.BaseContentType;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectschema.model.IAbstractBackReferenceModel;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IContentModel;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modelexaminer.IContentModelExaminer;
import ch.nolix.systemapi.objectschema.schematool.IColumnTool;

public final class ColumnTool
extends DatabaseObjectExaminer
implements IColumnTool {
    private static final IContentModelExaminer CONTENT_MODEL_EXAMINER = new ContentModelExaminer();

    @Override
    public void assertBelongsToTable(IColumn column) {
        if (!column.belongsToTable()) {
            throw ArgumentDoesNotBelongToParentException.forArgumentAndParentType(column, ITable.class);
        }
    }

    @Override
    public void assertDoesNotBelongToTable(IColumn column) {
        if (column.belongsToTable()) {
            throw ArgumentBelongsToParentException.forArgumentAndParent(column, column.getStoredParentTable());
        }
    }

    @Override
    public void assertIsABackReferenceColumn(IColumn column) {
        if (!this.isABackReferenceColumn(column)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(column, "is not a back reference column");
        }
    }

    @Override
    public void assertIsAReferenceColumn(IColumn column) {
        if (!this.isAReferenceColumn(column)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(column, "is not any reference column");
        }
    }

    @Override
    public boolean belongsToDatabase(IColumn column) {
        return column.belongsToTable() && ((ITable)column.getStoredParentTable()).belongsToDatabase();
    }

    @Override
    public BaseContentType getBaseFieldType(IColumn column) {
        return this.getFieldType(column).getBaseType();
    }

    @Override
    public ContentType getFieldType(IColumn column) {
        return column.getContentModel().getContentType();
    }

    @Override
    public IDatabase getParentDatabase(IColumn column) {
        return (IDatabase)((ITable)column.getStoredParentTable()).getStoredParentDatabase();
    }

    @Override
    public boolean isABackReferenceColumn(IColumn column) {
        IContentModel contentModel = column.getContentModel();
        return CONTENT_MODEL_EXAMINER.isAbstractBackReferenceModel(contentModel);
    }

    @Override
    public boolean isAReferenceColumn(IColumn column) {
        IContentModel contentModel = column.getContentModel();
        return CONTENT_MODEL_EXAMINER.isAbstractReferenceModel(contentModel);
    }

    @Override
    public boolean isAValueColumn(IColumn column) {
        IContentModel contentModel = column.getContentModel();
        return CONTENT_MODEL_EXAMINER.isAbstractValueModel(contentModel);
    }

    @Override
    public boolean isAValidBackReferenceColumn(IColumn column) {
        IContentModel contentModel = column.getContentModel();
        if (contentModel instanceof IAbstractBackReferenceModel) {
            IAbstractBackReferenceModel abstractBackReferenceModel = (IAbstractBackReferenceModel)contentModel;
            IColumn backReferencedColumn = abstractBackReferenceModel.getBackReferencedColumn();
            IContentModel backReferencedColumnContentModel = backReferencedColumn.getContentModel();
            if (!CONTENT_MODEL_EXAMINER.isAbstractReferenceModel(backReferencedColumnContentModel)) {
                return false;
            }
            return this.referencesGivenTable(backReferencedColumn, (ITable)column.getStoredParentTable());
        }
        return false;
    }

    @Override
    public boolean referencesBackGivenColumn(IColumn column, IColumn probableBackReferencedColumn) {
        return column.getContentModel().referencesBackColumn(probableBackReferencedColumn);
    }

    @Override
    public boolean referencesGivenTable(IColumn column, ITable table) {
        return column.getContentModel().referencesTable(table);
    }
}

