/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.schematool;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotContainElementException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectschema.modelexaminer.DatabaseExaminer;
import ch.nolix.system.objectschema.schematool.ColumnTool;
import ch.nolix.system.objectschema.schematool.TableTool;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.modelexaminer.IDatabaseExaminer;
import ch.nolix.systemapi.objectschema.schematool.IColumnTool;
import ch.nolix.systemapi.objectschema.schematool.IDatabaseTool;
import ch.nolix.systemapi.objectschema.schematool.ITableTool;

public final class DatabaseTool
extends DatabaseObjectExaminer
implements IDatabaseTool {
    private static final IDatabaseExaminer DATABASE_EXAMINER = new DatabaseExaminer();
    private static final ITableTool TABLE_TOOL = new TableTool();
    private static final IColumnTool COLUMN_TOOL = new ColumnTool();

    @Override
    public boolean allBackReferencesAreValid(IDatabase database) {
        return this.getStoredAllBackReferenceColumns(database).containsOnly(COLUMN_TOOL::isAValidBackReferenceColumn);
    }

    @Override
    public void assertAllBackReferencesAreValid(IDatabase database) {
        if (!this.allBackReferencesAreValid(database)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(database, "contains invalid back references");
        }
    }

    @Override
    public void assertCanAddGivenTable(IDatabase database, ITable table) {
        if (!DATABASE_EXAMINER.canAddTable(database, table)) {
            if (table == null) {
                throw ArgumentIsNullException.forArgumentName("table");
            }
            throw InvalidArgumentException.forArgumentAndErrorPredicate(database, "cannot add the given table '" + table.getName() + "'");
        }
    }

    @Override
    public void assertCanSetGivenNameToDatabase(String name) {
        if (!DATABASE_EXAMINER.canSetName(name)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate("name", name, "cannot be set to database");
        }
    }

    @Override
    public void assertContainsTableReferencedByGivenColumn(IDatabase database, IColumn column) {
        if (!DATABASE_EXAMINER.containsTableReferencedByColumn(database, column)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(database, "does not contain a table that is referenced by the column " + column.getNameInQuotes());
        }
    }

    @Override
    public void assertContainsTableWithColumnBackReferencedByGivenColumn(IDatabase database, IColumn column) {
        if (!DATABASE_EXAMINER.containsBackReferencededColumnByColumn(database, column)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not contain a table with a column that references back the column " + column.getName());
        }
    }

    @Override
    public void assertContainsTableWithGivenColumn(IDatabase database, IColumn column) {
        if (!DATABASE_EXAMINER.containsTableWithColumn(database, column)) {
            throw ArgumentDoesNotContainElementException.forArgumentAndElement(this, column);
        }
    }

    @Override
    public void assertDoesNotContainTableWithGivenName(IDatabase database, String name) {
        if (DATABASE_EXAMINER.containsTableWithName(database, name)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "contains a table with the name '" + name + "'");
        }
    }

    @Override
    public void deleteTableWithGivenName(IDatabase database, String name) {
        this.getStoredTableWithGivenName(database, name).delete();
    }

    @Override
    public IContainer<? extends IColumn> getStoredAllBackReferenceColumns(IDatabase database) {
        return database.getStoredTables().toMultiples(TABLE_TOOL::getStoredBackReferenceColumns);
    }

    @Override
    public ITable getStoredTableWithGivenName(IDatabase database, String name) {
        return database.getStoredTables().getStoredFirst(t -> t.hasName(name));
    }

    @Override
    public int getTableCount(IDatabase database) {
        return database.getStoredTables().getCount();
    }
}

