/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.schematool;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectschema.schematool.ColumnTool;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.IDatabase;
import ch.nolix.systemapi.objectschema.model.ITable;
import ch.nolix.systemapi.objectschema.schematool.IColumnTool;
import ch.nolix.systemapi.objectschema.schematool.ITableTool;

public final class TableTool
extends DatabaseObjectExaminer
implements ITableTool {
    private static final IColumnTool COLUMN_TOOL = new ColumnTool();

    @Override
    public int getColumnCount(ITable table) {
        return table.getStoredColumns().getCount();
    }

    @Override
    public IContainer<? extends IColumn> getStoredBackReferenceColumns(ITable table) {
        return table.getStoredColumns().getStoredSelected(COLUMN_TOOL::isABackReferenceColumn);
    }

    @Override
    public IContainer<? extends IColumn> getStoredBackReferencingColumns(ITable table) {
        if (!table.belongsToDatabase()) {
            return this.getStoredBackReferencingColumnsWhenDoesNotBelongToDatabase(table);
        }
        return this.getStoredBackReferencingColumnsWhenBelongsToDatabase(table);
    }

    @Override
    public IContainer<? extends IColumn> getStoredReferencingColumns(ITable table) {
        if (!table.belongsToDatabase()) {
            return this.getStoredReferencingColumnsWhenDoesNotBelongToDatabase(table);
        }
        return this.getStoredReferencingColumnsWhenBelongsToDatabase(table);
    }

    private IContainer<? extends IColumn> getStoredBackReferencingColumnsWhenBelongsToDatabase(ITable table) {
        IContainer columns = ((IDatabase)table.getStoredParentDatabase()).getStoredTables().toMultiples(ITable::getStoredColumns);
        return table.getStoredColumns().getStoredSelected(c -> columns.containsAny(c2 -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, (IColumn)c2)));
    }

    private IContainer<? extends IColumn> getStoredBackReferencingColumnsWhenDoesNotBelongToDatabase(ITable table) {
        IContainer<? extends IColumn> columns = table.getStoredColumns();
        return columns.getStoredSelected(c -> columns.containsAny(c2 -> COLUMN_TOOL.referencesBackGivenColumn((IColumn)c, (IColumn)c2)));
    }

    private IContainer<? extends IColumn> getStoredReferencingColumnsWhenBelongsToDatabase(ITable table) {
        return ((IDatabase)table.getStoredParentDatabase()).getStoredTables().toMultiples(ITable::getStoredColumns).getStoredSelected(c -> COLUMN_TOOL.referencesGivenTable((IColumn)c, table));
    }

    private IContainer<? extends IColumn> getStoredReferencingColumnsWhenDoesNotBelongToDatabase(ITable table) {
        return table.getStoredColumns().getStoredSelected(c -> COLUMN_TOOL.referencesGivenTable((IColumn)c, table));
    }
}

