/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmiddata.datareader;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.sql.connection.AbstractSqlConnection;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.coreapi.sql.model.ISqlRecord;
import ch.nolix.system.middata.valuemapper.ValueMapper;
import ch.nolix.system.sqlmiddata.modelmapper.LoadedEntityDtoMapper;
import ch.nolix.system.sqlmiddata.modelmapper.MultiReferenceEntryDtoMapper;
import ch.nolix.system.sqlmiddata.querycreator.EntityQueryCreator;
import ch.nolix.system.sqlmiddata.querycreator.MultiBackReferenceQueryCreator;
import ch.nolix.system.sqlmiddata.querycreator.MultiReferenceQueryCreator;
import ch.nolix.system.sqlmiddata.querycreator.MultiValueQueryCreator;
import ch.nolix.system.time.moment.Time;
import ch.nolix.systemapi.middata.model.EntityLoadingDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDto;
import ch.nolix.systemapi.middata.valuemapper.IValueMapper;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.DatabaseViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.sqlmiddata.modelmapper.IMultiReferenceEntryDtoMapper;
import ch.nolix.systemapi.sqlmiddata.querycreator.IEntityQueryCreator;
import ch.nolix.systemapi.sqlmiddata.querycreator.IMultiBackReferenceQueryCreator;
import ch.nolix.systemapi.sqlmiddata.querycreator.IMultiReferenceQueryCreator;
import ch.nolix.systemapi.sqlmiddata.querycreator.IMultiValueQueryCreator;

final class InternalDataReader {
    private static final IEntityQueryCreator ENTITY_QUERY_CREATOR = new EntityQueryCreator();
    private static final IMultiValueQueryCreator MULTI_VALUE_QUERY_CREATOR = new MultiValueQueryCreator();
    private static final IMultiReferenceQueryCreator MULTI_REFERENCE_QUERY_CREATOR = new MultiReferenceQueryCreator();
    private static final IMultiBackReferenceQueryCreator MULTI_BACK_REFERENCE_QUERY_CREATOR = new MultiBackReferenceQueryCreator();
    private static final LoadedEntityDtoMapper LOADED_ENTITY_DTO_MAPPER = new LoadedEntityDtoMapper();
    private static final IMultiReferenceEntryDtoMapper MULTI_REFERENCE_ENTRY_DTO_MAPPER = new MultiReferenceEntryDtoMapper();
    private static final IValueMapper VALUE_MAPPER = new ValueMapper();
    private final String databaseName;
    private final ISqlConnection sqlConnection;

    public InternalDataReader(String databaseName, ISqlConnection sqlConnection) {
        Validator.assertThat(databaseName).thatIsNamed("database name").isNotBlank();
        Validator.assertThat(sqlConnection).thatIsNamed(AbstractSqlConnection.class).isNotNull();
        this.databaseName = databaseName;
        this.sqlConnection = sqlConnection;
        sqlConnection.executeStatement("USE " + databaseName, new String[0]);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Time getSchemaTimestamp() {
        return Time.fromString((String)this.sqlConnection.getSingleRecordFromQuery(ENTITY_QUERY_CREATOR.createQueryToLoadSchemaTimestamp()).getStoredAtOneBasedIndex(1));
    }

    public IContainer<String> loadMultiBackReferenceEntries(String entityId, String multiBackReferenceColumnId) {
        String query = MULTI_BACK_REFERENCE_QUERY_CREATOR.createQueryToLoadMultiBackReferenceEntries(entityId, multiBackReferenceColumnId);
        return this.sqlConnection.getRecordsFromQuery(query).to(r -> (String)r.getStoredAtOneBasedIndex(1));
    }

    public IContainer<MultiReferenceEntryDto> loadMultiReferenceEntries(String entityId, String multiReferenceColumnId, DatabaseViewDto databaseView) {
        String query = MULTI_REFERENCE_QUERY_CREATOR.createQueryToLoadMultiReferenceEntries(entityId, multiReferenceColumnId);
        IContainer<ISqlRecord> sqlRecords = this.sqlConnection.getRecordsFromQuery(query);
        return sqlRecords.to(r -> MULTI_REFERENCE_ENTRY_DTO_MAPPER.mapMultiReferenceEntrySqlRecordToMultiReferenceEntryDto((ISqlRecord)r, databaseView));
    }

    public IContainer<Object> loadMultiValueEntries(String entityId, ColumnViewDto multiValueColumnView) {
        return this.sqlConnection.getRecordsFromQuery(MULTI_VALUE_QUERY_CREATOR.createQueryToLoadMultiValueEntries(entityId, multiValueColumnView.id())).to(r -> VALUE_MAPPER.mapStringToValue((String)r.getStoredAtOneBasedIndex(1), multiValueColumnView.dataType()));
    }

    public IContainer<EntityLoadingDto> loadEntitiesOfTable(TableViewDto tableView) {
        String query = ENTITY_QUERY_CREATOR.createQueryToLoadEntitiesOfTable(tableView);
        IContainer<ISqlRecord> records = this.sqlConnection.getRecordsFromQuery(query);
        return records.to(r -> LOADED_ENTITY_DTO_MAPPER.mapSqlRecordToEntityLoadingDto((ISqlRecord)r, tableView));
    }

    public EntityLoadingDto loadEntity(TableViewDto tableView, String id) {
        String query = ENTITY_QUERY_CREATOR.createQueryToLoadEntity(id, tableView);
        ISqlRecord sqlRecord = this.sqlConnection.getSingleRecordFromQuery(query);
        return LOADED_ENTITY_DTO_MAPPER.mapSqlRecordToEntityLoadingDto(sqlRecord, tableView);
    }

    public boolean tableContainsEntityWithGivenValueAtGivenColumn(String tableName, ColumnViewDto columnView, String value) {
        ContentType contentType = columnView.contentType();
        return switch (contentType) {
            case ContentType.VALUE, ContentType.OPTIONAL_VALUE, ContentType.REFERENCE, ContentType.OPTIONAL_REFERENCE, ContentType.BACK_REFERENCE, ContentType.OPTIONAL_BACK_REFERENCE -> this.tableContainsEntityWithGivenValueAtGivenSingleColumn(tableName, columnView.name(), value);
            case ContentType.MULTI_VALUE -> this.multiValueEntryExistsForGivenColumnAndValue(columnView.id(), value);
            case ContentType.MULTI_REFERENCE -> this.multiReferenceEntryExistsForGivenColumnAndReferencedEntity(columnView.id(), value);
            default -> throw InvalidArgumentException.forArgument((Object)contentType);
        };
    }

    public boolean tableContainsEntityWithGivenValueAtGivenColumnIgnoringGivenEntities(String tableName, ColumnViewDto columnInfo, String value, IContainer<String> entitiesToIgnoreIds) {
        ContentType contentType = columnInfo.contentType();
        return switch (contentType) {
            case ContentType.VALUE, ContentType.OPTIONAL_VALUE, ContentType.REFERENCE, ContentType.OPTIONAL_REFERENCE, ContentType.BACK_REFERENCE, ContentType.OPTIONAL_BACK_REFERENCE -> this.tableContainsEntityWithGivenValueAtGivenSingleColumnIgnoringGivenEntities(tableName, columnInfo.name(), value, entitiesToIgnoreIds);
            case ContentType.MULTI_VALUE -> this.multiValueEntryExistsForGivenColumnAndValueIgnoringGivenEntities(columnInfo.id(), value, entitiesToIgnoreIds);
            case ContentType.MULTI_REFERENCE -> this.multiReferenceEntryExistsForGivenColumnAndReferencedEntityIgnoringGivenEntities(columnInfo.id(), value, entitiesToIgnoreIds);
            default -> throw InvalidArgumentException.forArgument((Object)contentType);
        };
    }

    public boolean tableContainsEntityWithGivenId(String tableName, String id) {
        Integer entityCount = Integer.valueOf((String)this.sqlConnection.getSingleRecordFromQuery(ENTITY_QUERY_CREATOR.createQueryToCountEntitiesWithGivenId(tableName, id)).getStoredAtOneBasedIndex(1));
        return entityCount > 0;
    }

    private boolean multiReferenceEntryExistsForGivenColumnAndReferencedEntity(String columnId, String referencedEntityId) {
        return this.sqlConnection.getRecordsFromQuery(MULTI_REFERENCE_QUERY_CREATOR.createQueryToLoadOptionalFirstMultiReferenceEntry(columnId, referencedEntityId)).containsAny();
    }

    private boolean multiReferenceEntryExistsForGivenColumnAndReferencedEntityIgnoringGivenEntities(String columnId, String referencedEntityId, IContainer<String> entitiesToIgnoreIds) {
        String query = MULTI_REFERENCE_QUERY_CREATOR.createQueryToCountMultiReferenceEntriesForGivenColumnAndReferencedEntityIgnoringGivenEntities(columnId, referencedEntityId, entitiesToIgnoreIds);
        ISqlRecord localRecord = this.sqlConnection.getSingleRecordFromQuery(query);
        Integer entityCount = Integer.valueOf((String)localRecord.getStoredFirst());
        return entityCount > 0;
    }

    private boolean multiValueEntryExistsForGivenColumnAndValue(String columnId, String value) {
        return this.sqlConnection.getRecordsFromQuery(MULTI_VALUE_QUERY_CREATOR.createQueryToLoadOneOrNoneMultiValueEntryForGivenColumnAndValue(columnId, value)).containsAny();
    }

    private boolean multiValueEntryExistsForGivenColumnAndValueIgnoringGivenEntities(String columnId, String value, IContainer<String> entitiesToIgnoreIds) {
        String query = MULTI_VALUE_QUERY_CREATOR.createQueryToCountMultiValueEntriesForGivenColumnAndValueIgnoringGivenEntities(columnId, value, entitiesToIgnoreIds);
        ISqlRecord localRecord = this.sqlConnection.getSingleRecordFromQuery(query);
        Integer entityCount = Integer.valueOf((String)localRecord.getStoredFirst());
        return entityCount > 0;
    }

    private boolean tableContainsEntityWithGivenValueAtGivenSingleColumn(String tableName, String singleColumnName, String value) {
        return Integer.valueOf((String)this.sqlConnection.getSingleRecordFromQuery(ENTITY_QUERY_CREATOR.createQueryToCountEntitiesWithGivenValueAtGivenColumn(tableName, singleColumnName, value)).getStoredAtOneBasedIndex(1)) > 0;
    }

    private boolean tableContainsEntityWithGivenValueAtGivenSingleColumnIgnoringGivenEntities(String tableName, String columnName, String value, IContainer<String> entitiesToIgnoreIds) {
        String query = ENTITY_QUERY_CREATOR.createQueryToCountEntitiesWithGivenValueAtGivenColumnIgnoringGivenEntities(tableName, columnName, value, entitiesToIgnoreIds);
        ISqlRecord localRecord = this.sqlConnection.getSingleRecordFromQuery(query);
        Integer entityCount = Integer.valueOf((String)localRecord.getStoredFirst());
        return entityCount > 0;
    }
}

