/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmidschema.schemawriter;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.sql.sqltool.SqlCollector;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.sql.sqltool.ISqlCollector;
import ch.nolix.system.sqlmidschema.statementcreator.DatabasePropertiesStatementCreator;
import ch.nolix.system.sqlmidschema.statementcreator.MetaDataStatementCreator;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.sqlmidschema.statementcreator.IDatabasePropertiesStatementCreator;
import ch.nolix.systemapi.sqlmidschema.statementcreator.IMetaDataStatementCreator;
import ch.nolix.systemapi.time.moment.ITime;

public final class MetaDataWriter {
    private static final IDatabasePropertiesStatementCreator DATABASE_PROPERTIES_STATEMENT_CREATOR = new DatabasePropertiesStatementCreator();
    private static final IMetaDataStatementCreator META_DATA_STATEMENT_CREATOR = new MetaDataStatementCreator();
    private final ISqlCollector sqlCollector;

    private MetaDataWriter(ISqlCollector sqlCollector) {
        Validator.assertThat(sqlCollector).thatIsNamed(SqlCollector.class).isNotNull();
        this.sqlCollector = sqlCollector;
    }

    public static MetaDataWriter forSqlCollector(ISqlCollector sqlCollector) {
        return new MetaDataWriter(sqlCollector);
    }

    public void addColumn(String tableName, ColumnDto column) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToAddColumn(tableName, column);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void deleteColumn(String tableName, String columnName) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToDeleteColumn(tableName, columnName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void addTable(TableDto table) {
        IContainer<String> statements = META_DATA_STATEMENT_CREATOR.createStatementsToAddTable(table);
        this.sqlCollector.addSqlStatements(statements);
    }

    public void deleteTable(String tableName) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToDeleteTable(tableName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void renameColumn(String tableName, String columnName, String newColumnName) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToRenameColumn(tableName, columnName, newColumnName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void renameTable(String tableName, String newTableName) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToRenameTable(tableName, newTableName);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void setContentModel(String tableName, String columnName, IContentModelDto contentModel) {
        String statement = META_DATA_STATEMENT_CREATOR.createStatementToSetContentModel(tableName, columnName, contentModel);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void setSchemaTimestamp(ITime schemaTimestamp) {
        String statement = DATABASE_PROPERTIES_STATEMENT_CREATOR.createStatementToSetSchemaTimestamp(schemaTimestamp);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }
}

