/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.stylable;

import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.style.model.Style;
import ch.nolix.system.style.stylable.AbstractStylableElement;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.style.model.IStyle;
import ch.nolix.systemapi.style.stylable.IStyleElement;

public abstract class AbstractStyleElement<E extends AbstractStyleElement<E>>
extends AbstractStylableElement<E>
implements IStyleElement<E> {
    private static final String CONFIGURATION_HEADER = "Configuration";
    private final MutableOptionalValue<IStyle> style = new MutableOptionalValue<IStyle>("Configuration", iStyle -> this.setStyle((IStyle)iStyle), Style::fromSpecification, IElement::getSpecification);

    @Override
    public void applyStyleIfHasStyle() {
        if (this.hasStyle()) {
            this.resetStyleRecursively();
            this.getStoredConfiguration().applyToElement(this);
        }
    }

    @Override
    public final boolean hasStyle() {
        return this.style.containsAny();
    }

    @Override
    public final void removeStyle() {
        this.style.clear();
        this.resetStyleRecursively();
    }

    @Override
    public E setStyle(IStyle style) {
        this.style.setValue(style);
        this.applyStyleIfHasStyle();
        return (E)((AbstractStyleElement)this.asConcrete());
    }

    @Override
    protected final void resetStylableElement() {
        this.removeStyle();
        this.resetConfigurationElement();
    }

    protected abstract void resetConfigurationElement();

    private IStyle getStoredConfiguration() {
        return (IStyle)this.style.getValue();
    }
}

