/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.style.tool;

import ch.nolix.core.container.arraylist.ArrayList;
import ch.nolix.core.datastructure.pair.Pair;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datastructure.pair.IPair;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.systemapi.style.model.IAttachingAttribute;
import ch.nolix.systemapi.style.tool.IAttributeReplacer;
import java.util.Optional;

public final class AttributeReplacer
implements IAttributeReplacer {
    @Override
    public IContainer<IAttachingAttribute> getReplacedAttributesFromAttributesAndAttributeReplacements(IContainer<? extends IAttachingAttribute> attributes, IContainer<IPair<String, String>> attributeReplacements) {
        ArrayList<IAttachingAttribute> replacedAttributes = ArrayList.withInitialCapacityFromSizeOfContainer(attributes);
        for (IAttachingAttribute iAttachingAttribute : attributes) {
            String attributeValue = ((INode)iAttachingAttribute.getValue()).toString();
            Optional<IPair> attributeReplacement = attributeReplacements.getOptionalStoredFirst(ar -> ((String)ar.getStoredElement1()).equals(attributeValue));
            if (attributeReplacement.isPresent()) {
                IAttachingAttribute replacingAttribute = iAttachingAttribute.withValue((String)attributeReplacement.get().getStoredElement2());
                replacedAttributes.addAtEnd(replacingAttribute);
                continue;
            }
            replacedAttributes.addAtEnd(iAttachingAttribute);
        }
        return replacedAttributes;
    }

    @Override
    public IContainer<IAttachingAttribute> getReplacedTaggedAttributesFromAttributesAndAttributeReplacements(IContainer<? extends IAttachingAttribute> attributes, IContainer<IPair<Enum<?>, String>> attributeReplacements) {
        ArrayList<IAttachingAttribute> replacedAttributes = ArrayList.withInitialCapacityFromSizeOfContainer(attributes);
        IContainer<Pair> localAttributeReplacements = attributeReplacements.to(r -> new Pair<String, String>(((Enum)r.getStoredElement1()).toString(), (String)r.getStoredElement2()));
        for (IAttachingAttribute iAttachingAttribute : attributes) {
            if (iAttachingAttribute.hasTag()) {
                String attributeTag = iAttachingAttribute.getTag();
                Optional<Pair> attributeReplacement = localAttributeReplacements.getOptionalStoredFirst(r -> ((String)r.getStoredElement1()).equals(attributeTag));
                if (attributeReplacement.isPresent()) {
                    IAttachingAttribute replacingAttribute = iAttachingAttribute.withValue((String)attributeReplacement.get().getStoredElement2());
                    replacedAttributes.addAtEnd(replacingAttribute);
                    continue;
                }
                replacedAttributes.addAtEnd(iAttachingAttribute);
                continue;
            }
            replacedAttributes.addAtEnd(iAttachingAttribute);
        }
        return replacedAttributes;
    }
}

