/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.time.moment;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnrepresentingArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.systemapi.time.moment.ITime;
import ch.nolix.systemapi.time.timestructure.Month;
import ch.nolix.systemapi.time.timestructure.Weekday;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public final class Time
extends AbstractElement
implements ITime {
    public static final int DEFAULT_YEAR = 2000;
    public static final int DEFAULT_MONTH_OF_YEAR = 1;
    public static final int DEFAULT_DAY_OF_MONTH = 1;
    public static final int DEFAULT_HOUR_OF_DAY = 0;
    public static final int DEFAULT_MINUTE_OF_HOUR = 0;
    public static final int DEFAULT_SECOND_OF_MINUTE = 0;
    public static final int DEFAULT_MILLISECOND_OF_SECOND = 0;
    public static final int DEFAULT_MICROSECOND_OF_MILLISECOND = 0;
    private static final Time DEFAULT_INSTANCE = Time.forZonedDateTime(ZonedDateTime.of(2000, 1, 1, 0, 0, 0, 0, ZoneId.systemDefault()));
    private final ZonedDateTime internalZonedDateTime;

    private Time(ZonedDateTime zonedDateTime) {
        Validator.assertThat(zonedDateTime).thatIsNamed(ZonedDateTime.class).isNotNull();
        this.internalZonedDateTime = zonedDateTime;
    }

    public static Time forZonedDateTime(ZonedDateTime zonedDateTime) {
        return new Time(zonedDateTime);
    }

    public static Time fromSpecification(INode<?> specification) {
        return Time.fromString(specification.getSingleChildNodeHeader());
    }

    public static Time fromString(String string) {
        Validator.assertThat(string).thatIsNamed("string").isNotNull();
        String[] values = string.split("-");
        return switch (values.length) {
            case 3 -> Time.fromArrayWith3Values(values);
            case 5 -> Time.fromArrayWith5Values(values);
            case 6 -> Time.fromArrayWith6Values(values);
            case 7 -> Time.fromArrayWith7Values(values);
            case 8 -> Time.fromArrayWith8Values(values);
            default -> throw UnrepresentingArgumentException.forArgumentAndType(string, Time.class);
        };
    }

    public static Time ofNow() {
        return new Time(ZonedDateTime.now());
    }

    public static Time withYear(int year) {
        return new Time(Time.DEFAULT_INSTANCE.internalZonedDateTime.withYear(year));
    }

    public static Time withYearAndMonthOfYear(int year, int monthOfYear) {
        return new Time(Time.DEFAULT_INSTANCE.internalZonedDateTime.withYear(year).withMonth(monthOfYear));
    }

    public static Time withYearAndMonthOfYearAndDayOfMonth(int year, int monthOfYear, int dayOfMonth) {
        return new Time(Time.DEFAULT_INSTANCE.internalZonedDateTime.withYear(year).withMonth(monthOfYear).withDayOfMonth(dayOfMonth));
    }

    public static Time withYearAndMonthOfYearAndDayOfMonthAndHourOfDay(int year, int monthOfYear, int dayOfMonth, int hourOfDay) {
        return new Time(Time.DEFAULT_INSTANCE.internalZonedDateTime.withYear(year).withMonth(monthOfYear).withDayOfMonth(dayOfMonth).withHour(hourOfDay));
    }

    public static Time withYearAndMonthOfYearAndDayOfMonthAndHourOfDayAndMinOfHour(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour) {
        return new Time(Time.DEFAULT_INSTANCE.internalZonedDateTime.withYear(year).withMonth(monthOfYear).withDayOfMonth(dayOfMonth).withHour(hourOfDay).withMinute(minuteOfHour));
    }

    public static Time withYearAndMonthOfYearAndDayOfMonthAndHourOfDayAndMinOfHourAndSecOfMin(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        return new Time(Time.DEFAULT_INSTANCE.internalZonedDateTime.withYear(year).withMonth(monthOfYear).withDayOfMonth(dayOfMonth).withHour(hourOfDay).withMinute(minuteOfHour).withSecond(secondOfMinute));
    }

    public static Time withYearAndMonthOfYearAndDayOfMonthAndHourOfDayAndMinOfHourAndSecOfMinAndMillisecOfSec(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondOfSecond) {
        int nanoSecondsOfSecond = 1000000 * millisecondOfSecond;
        return new Time(Time.DEFAULT_INSTANCE.internalZonedDateTime.withYear(year).withMonth(monthOfYear).withDayOfMonth(dayOfMonth).withHour(hourOfDay).withMinute(minuteOfHour).withSecond(secondOfMinute).withNano(nanoSecondsOfSecond));
    }

    public static Time withYearAndMonthOfYearAndDayOfMonthAndHourOfDayAndMinOfHourAndSecOfMinAndMillisecOfSecAndMicrosecOfMillisec(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondOfSecond, int microsecondsOfMilliSecond) {
        int nanoSecondsOfSecond = 1000000 * millisecondOfSecond + 1000 * microsecondsOfMilliSecond;
        return new Time(Time.DEFAULT_INSTANCE.internalZonedDateTime.withYear(year).withMonth(monthOfYear).withDayOfMonth(dayOfMonth).withHour(hourOfDay).withMinute(minuteOfHour).withSecond(secondOfMinute).withNano(nanoSecondsOfSecond));
    }

    private static Time fromArrayWith3Values(String[] arrayWith3Values) {
        return Time.withYearAndMonthOfYearAndDayOfMonth(Integer.valueOf(arrayWith3Values[0]), Integer.valueOf(arrayWith3Values[1]), Integer.valueOf(arrayWith3Values[2]));
    }

    private static Time fromArrayWith5Values(String[] arrayWith5Values) {
        return Time.withYearAndMonthOfYearAndDayOfMonthAndHourOfDayAndMinOfHour(Integer.valueOf(arrayWith5Values[0]), Integer.valueOf(arrayWith5Values[1]), Integer.valueOf(arrayWith5Values[2]), Integer.valueOf(arrayWith5Values[3]), Integer.valueOf(arrayWith5Values[4]));
    }

    private static Time fromArrayWith6Values(String[] arrayWith6Values) {
        return Time.withYearAndMonthOfYearAndDayOfMonthAndHourOfDayAndMinOfHourAndSecOfMin(Integer.valueOf(arrayWith6Values[0]), Integer.valueOf(arrayWith6Values[1]), Integer.valueOf(arrayWith6Values[2]), Integer.valueOf(arrayWith6Values[3]), Integer.valueOf(arrayWith6Values[4]), Integer.valueOf(arrayWith6Values[5]));
    }

    private static Time fromArrayWith7Values(String[] arrayWith7Values) {
        return Time.withYearAndMonthOfYearAndDayOfMonthAndHourOfDayAndMinOfHourAndSecOfMinAndMillisecOfSec(Integer.valueOf(arrayWith7Values[0]), Integer.valueOf(arrayWith7Values[1]), Integer.valueOf(arrayWith7Values[2]), Integer.valueOf(arrayWith7Values[3]), Integer.valueOf(arrayWith7Values[4]), Integer.valueOf(arrayWith7Values[5]), Integer.valueOf(arrayWith7Values[6]));
    }

    private static Time fromArrayWith8Values(String[] arrayWith8Values) {
        return Time.withYearAndMonthOfYearAndDayOfMonthAndHourOfDayAndMinOfHourAndSecOfMinAndMillisecOfSecAndMicrosecOfMillisec(Integer.valueOf(arrayWith8Values[0]), Integer.valueOf(arrayWith8Values[1]), Integer.valueOf(arrayWith8Values[2]), Integer.valueOf(arrayWith8Values[3]), Integer.valueOf(arrayWith8Values[4]), Integer.valueOf(arrayWith8Values[5]), Integer.valueOf(arrayWith8Values[6]), Integer.valueOf(arrayWith8Values[7]));
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        String timeCode = String.format("%04d-%02d-%02d-%02d-%02d-%02d-%03d-%03d", this.getYear(), this.getMonthOfYearAsInt(), this.getDayOfMonth(), this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute(), this.getMillisecondOfSecond(), this.getMicrosecondOfMillisecond());
        Node attribute = Node.withHeader(timeCode);
        return LinkedList.withElement(attribute, new INode[0]);
    }

    @Override
    public int getDayOfMonth() {
        return this.internalZonedDateTime.getDayOfMonth();
    }

    @Override
    public int getHourOfDay() {
        return this.internalZonedDateTime.getHour();
    }

    @Override
    public int getMicrosecondOfMillisecond() {
        return this.internalZonedDateTime.getNano() / 1000 % 1000;
    }

    @Override
    public int getMillisecondOfSecond() {
        return this.internalZonedDateTime.getNano() / 1000000;
    }

    @Override
    public int getMinuteOfHour() {
        return this.internalZonedDateTime.getMinute();
    }

    @Override
    public Month getMonthOfYear() {
        return Month.fromJavaMonth(this.internalZonedDateTime.getMonth());
    }

    @Override
    public int getMonthOfYearAsInt() {
        return this.internalZonedDateTime.getMonth().getValue();
    }

    @Override
    public int getSecondOfMinute() {
        return this.internalZonedDateTime.getSecond();
    }

    @Override
    public Weekday getWeekday() {
        return Weekday.fromDayOfWeek(this.internalZonedDateTime.getDayOfWeek());
    }

    @Override
    public int getYear() {
        return this.internalZonedDateTime.getYear();
    }

    @Override
    public boolean isAfter(ITime time) {
        return this.toSeconds() > time.toSeconds();
    }

    @Override
    public boolean isBefore(ITime time) {
        return this.toSeconds() < time.toSeconds();
    }

    @Override
    public boolean isInLeapYear() {
        return Year.isLeap(this.getYear());
    }

    @Override
    public long toSeconds() {
        return this.internalZonedDateTime.toEpochSecond();
    }

    @Override
    public Time withAddedOrSubtractedDays(int days) {
        return new Time(this.internalZonedDateTime.plusDays(days));
    }

    @Override
    public Time withAddedOrSubtractedHours(int hours) {
        return new Time(this.internalZonedDateTime.plusHours(hours));
    }

    @Override
    public ITime withAddedOrSubtractedMicroseconds(long microseconds) {
        long nanoseconds = 1000L * microseconds;
        return Time.forZonedDateTime(this.internalZonedDateTime.plusNanos(nanoseconds));
    }

    @Override
    public Time withAddedOrSubtractedMilliseconds(int milliseconds) {
        int nanoSeconds = 1000000 * milliseconds;
        return Time.forZonedDateTime(this.internalZonedDateTime.plusNanos(nanoSeconds));
    }

    @Override
    public Time withAddedOrSubtractedMinutes(int minutes) {
        return Time.forZonedDateTime(this.internalZonedDateTime.plusMinutes(minutes));
    }

    @Override
    public Time withAddedOrSubtractedSeconds(int seconds) {
        return Time.forZonedDateTime(this.internalZonedDateTime.plusSeconds(seconds));
    }
}

