/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.web.cssmapper;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.web.css.CssProperty;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.css.ICssProperty;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.graphic.color.IColorGradient;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.graphic.imageproperty.Alignment;
import ch.nolix.systemapi.gui.background.IBackground;
import java.util.Locale;

public final class BackgroundToCssMapperHelper {
    private static final ICssProperty TRANSPARENT_BACKGROUND_CSS_PROPERTY = CssProperty.withNameAndValue("background", "none");
    public static final ImmutableList<ICssProperty> TRANSPARENT_BACKGROUND_CSS_PROPERTIES = ImmutableList.withElement(TRANSPARENT_BACKGROUND_CSS_PROPERTY, new ICssProperty[0]);

    private BackgroundToCssMapperHelper() {
    }

    private static String getColorCodeOfColor(IColor color) {
        if (color.hasFullAlphaValue()) {
            return String.format("#%02x%02x%02x", color.getRedValue(), color.getGreenValue(), color.getBlueValue());
        }
        return String.format(Locale.ENGLISH, "rgba(%d, %d, %d, %f)", color.getRedValue(), color.getGreenValue(), color.getBlueValue(), color.getAlphaPercentage());
    }

    private static String getDegreeCodeOfColorGradient(IColorGradient pColorGradient) {
        return BackgroundToCssMapperHelper.getDegreeOfColorGradient(pColorGradient) + "deg";
    }

    private static int getDegreeOfColorGradient(IColorGradient pColorGradient) {
        return BackgroundToCssMapperHelper.getDegreeOfDirection(pColorGradient.getDirection());
    }

    private static int getDegreeOfDirection(Alignment direction) {
        return switch (direction) {
            case Alignment.VERTICAL -> 180;
            case Alignment.HORIZONTAL -> 90;
            case Alignment.DIAGONAL_LEFT_DOWN -> 135;
            case Alignment.DIAGONAL_LEFT_UP -> 45;
            default -> throw InvalidArgumentException.forArgument((Object)direction);
        };
    }

    public static IContainer<ICssProperty> mapBackgroundToCssPropertiesWhenIsColor(IBackground background) {
        IColor color = background.getColor();
        String colorCode = BackgroundToCssMapperHelper.getColorCodeOfColor(color);
        CssProperty backgroundCssProperty = CssProperty.withNameAndValue("background", colorCode);
        return ImmutableList.withElement(backgroundCssProperty, new ICssProperty[0]);
    }

    public static IContainer<ICssProperty> mapBackgroundToCssPropertiesWhenIsColorGradient(IBackground background) {
        IColorGradient colorGradient = background.getColorGradient();
        String degreeCode = BackgroundToCssMapperHelper.getDegreeCodeOfColorGradient(colorGradient);
        String color1Code = BackgroundToCssMapperHelper.getColorCodeOfColor(colorGradient.getColor1());
        String color2Code = BackgroundToCssMapperHelper.getColorCodeOfColor(colorGradient.getColor2());
        String linearGradientCode = "linear-gradient(" + degreeCode + "," + color1Code + "," + color2Code + ")";
        CssProperty backgroundCssProperty = CssProperty.withNameAndValue("background", linearGradientCode);
        return ImmutableList.withElement(backgroundCssProperty, new ICssProperty[0]);
    }

    public static IContainer<ICssProperty> mapBackgroundToCssPropertiesWhenIsImage(IBackground background) {
        IImage image = background.getImage();
        String imageCode = "data:image/jpeg;base64," + image.toBase64Jpg();
        String imageUrl = "url('" + imageCode + "')";
        CssProperty backgroundImageCssProperty = CssProperty.withNameAndValue("background-image", imageUrl);
        return ImmutableList.withElement(backgroundImageCssProperty, CssProperty.withNameAndValue("background-size", "100% 100%"));
    }
}

