/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.base;

import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.net.target.IApplicationInstanceTarget;
import ch.nolix.coreapi.web.cookie.ICookieManager;
import ch.nolix.system.application.main.AbstractBackendClient;
import ch.nolix.system.webapplication.base.ClientCommandCreator;
import ch.nolix.system.webapplication.base.FileReader;
import ch.nolix.system.webapplication.base.RequestCreator;
import java.util.Optional;

public abstract class AbstractWebClient<C extends AbstractWebClient<C, S>, S>
extends AbstractBackendClient<C, S>
implements ICookieManager {
    private static final ClientCommandCreator BACKEND_WEB_CLIENT_COMMAND_CREATOR = new ClientCommandCreator();
    private static final RequestCreator BACKEND_WEB_CLIENT_REQUEST_CREATOR = new RequestCreator();
    private final FileReader fileReader = FileReader.forBackendWebClient(this);

    @Override
    public final void deleteCookieByName(String name) {
        ChainedNode deleteCookieCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createDeleteCookieByNameCommand(name);
        this.runOnCounterpart(deleteCookieCommand);
    }

    @Override
    public final Optional<String> getOptionalCookieValueByCookieName(String cookieName) {
        ChainedNode getCookieValueRequest = BACKEND_WEB_CLIENT_REQUEST_CREATOR.createGetCookieValueRequestForCookieName(cookieName);
        return this.getOptionalCookieValueByCookieNameFromData(this.getDataFromCounterpart(getCookieValueRequest));
    }

    public final Optional<String> getOptionalUrlParameterValueByUrlParameterName(String urlParameterName) {
        ChainedNode getUrlParameterValueRequest = BACKEND_WEB_CLIENT_REQUEST_CREATOR.createGetUrlParameterValueRequestForUrlParameterName(urlParameterName);
        INode<?> urlParameterValueReply = this.getDataFromCounterpart(getUrlParameterValueRequest);
        return urlParameterValueReply.getOptionalHeader();
    }

    @Override
    public final void setOrAddCookieWithNameAndValue(String name, String value) {
        ChainedNode setOrAddCookieCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createSetOrAddCookieCommandForCookieWithNameAndValue(name, value);
        this.runOnCounterpart(setOrAddCookieCommand);
    }

    @Override
    protected final void runHere(IChainedNode command) {
        switch (command.getHeader()) {
            case "ReceiveOptionalFile": {
                this.receiveOptionalFileFromCounterpart(command);
                break;
            }
            default: {
                this.runHereOnBaseBackendWebClient(command);
            }
        }
    }

    protected abstract void runHereOnBaseBackendWebClient(IChainedNode var1);

    final IContainer<byte[]> internalGetFilesFromClipboardOfCounterpart() {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "getFilesFromClipboard");
    }

    final String internalGetTextFromClipboardOfCounterpart() {
        ChainedNode getTextFromClipBoardCommand = BACKEND_WEB_CLIENT_REQUEST_CREATOR.createGetTextFromClipboardRequest();
        return this.getDataFromCounterpart(getTextFromClipBoardCommand).getHeader();
    }

    final void internalOpenNewTabOnCounterpartWithUrl(String url) {
        ChainedNode openNewTabCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createOpenNewTabCommand(url);
        this.runOnCounterpart(openNewTabCommand);
    }

    final Optional<byte[]> internalReadOptionalFileFromCounterpart() {
        return this.fileReader.readOptionalFileFromCounterpart();
    }

    final void internalRedirectCounterpartTo(IApplicationInstanceTarget applicationInstanceTarget) {
        ChainedNode redirectCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createRedirectCommand(applicationInstanceTarget);
        this.runOnCounterpart(redirectCommand);
    }

    final void internalRedirectCounterpartToUrl(String url) {
        ChainedNode redirectToUrlCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createRedirectToUrlCommand(url);
        this.runOnCounterpart(redirectToUrlCommand);
    }

    final void internalRunOnCounterpart(ChainedNode command) {
        this.runOnCounterpart(command);
    }

    final void internalSaveFileOnCounterpart(byte[] bytes) {
        ChainedNode saveFileCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createSaveFileCommand(bytes);
        this.runOnCounterpart(saveFileCommand);
    }

    final void internalWriteTextToClipboardOfCounterpart(String text) {
        ChainedNode writeTextToClipboardCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createWriteTextToClipBoardCommand(text);
        this.runOnCounterpart(writeTextToClipboardCommand);
    }

    private Optional<String> getOptionalCookieValueByCookieNameFromData(INode<?> data) {
        return data.getOptionalHeader();
    }

    private void receiveOptionalFileFromCounterpart(IChainedNode receiveOptionalFileCommand) {
        this.fileReader.receiveOptionalFileFromCounterpart(receiveOptionalFileCommand);
    }
}

