/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.base;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.net.target.IServerTarget;
import java.nio.charset.StandardCharsets;

final class ClientCommandCreator {
    ClientCommandCreator() {
    }

    public ChainedNode createDeleteCookieByNameCommand(String cookieName) {
        return ChainedNode.withHeaderAndChildNode("DeleteCookieByName", ChainedNode.withHeader(cookieName));
    }

    public ChainedNode createOpenNewTabCommand(String url) {
        return ChainedNode.withHeaderAndChildNode("OpenNewTab", ChainedNode.withHeaderAndChildNode("URL", ChainedNode.withHeader(url)));
    }

    public ChainedNode createRedirectCommand(IServerTarget serverTarget) {
        String url = serverTarget.toUrl();
        return this.createRedirectToUrlCommand(url);
    }

    public ChainedNode createRedirectToUrlCommand(String url) {
        return ChainedNode.withHeaderAndChildNode("Redirect", ChainedNode.withHeader(url));
    }

    public ChainedNode createSaveFileCommand(byte[] bytes) {
        return ChainedNode.withHeaderAndChildNodesFromNodes("SaveFile", Node.withHeader(new String(bytes, StandardCharsets.UTF_8)), new INode[0]);
    }

    public ChainedNode createSetOrAddCookieCommandForCookieWithNameAndValue(String name, String value) {
        return ChainedNode.withHeaderAndChildNodes("SetOrAddCookieWithNameAndValue", ImmutableList.withElement(ChainedNode.withHeader(name), ChainedNode.withHeader(value)));
    }

    public ChainedNode createWriteTextToClipBoardCommand(String text) {
        return ChainedNode.withHeaderAndChildNode("WriteTextToClipBoard", ChainedNode.withHeader(text));
    }
}

