/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.component;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.webapplication.component.BaseComponentCssBuilder;
import ch.nolix.system.webapplication.component.BaseComponentHtmlBuilder;
import ch.nolix.system.webapplication.component.BaseComponentStyle;
import ch.nolix.system.webapplication.component.Controller;
import ch.nolix.system.webapplication.main.WebClientSession;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.systemapi.webapplication.component.IComponent;
import ch.nolix.systemapi.webapplication.component.IComponentStyle;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;

public abstract class AbstractComponent<C extends Controller<S>, S>
extends Control<IComponent, IComponentStyle>
implements IComponent {
    private static final BaseComponentHtmlBuilder HTML_BUILDER = new BaseComponentHtmlBuilder();
    private static final BaseComponentCssBuilder CSS_BUILDER = new BaseComponentCssBuilder();
    private final C controller;

    protected AbstractComponent(C controller, WebClientSession<S> webClientSession) {
        Validator.assertThat(controller).thatIsNamed(Controller.class).isNotNull();
        this.controller = controller;
        ((Controller)this.controller).internalSetSession(webClientSession);
    }

    @Override
    public Optional<String> getOptionalJavaScriptUserInputFunction() {
        return Optional.empty();
    }

    @Override
    public final String getUserInput() {
        return "";
    }

    @Override
    public final boolean hasRole(String role) {
        return false;
    }

    @Override
    public final boolean isAlive() {
        return this.getStoredWebClientSession().isAlive();
    }

    @Override
    public final void refresh() {
        switch (this.getRefreshBehavior()) {
            case REFRESH_GUI: {
                this.rebuild();
                this.getStoredWebClientSession().refresh();
                break;
            }
            case REFRESH_SELF: {
                this.rebuild();
                this.getStoredWebClientSession().updateControlOnCounterpart(this, true);
                break;
            }
        }
    }

    @Override
    public final void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
    }

    @Override
    public final void runHtmlEvent(String htmlEvent) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "runHtmlEvent");
    }

    @Override
    public final IComponent setUserInput(String userInput) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "setUserInput");
    }

    @Override
    protected IComponentStyle createStyle() {
        return new BaseComponentStyle();
    }

    @Override
    protected final IControlCssBuilder<IComponent, IComponentStyle> getCssBuilder() {
        return CSS_BUILDER;
    }

    @Override
    protected final IControlHtmlBuilder<IComponent> getHtmlBuilder() {
        return HTML_BUILDER;
    }

    protected final S getStoredApplicationService() {
        return (S)((Controller)this.getStoredController()).getStoredApplicationService();
    }

    protected final C getStoredController() {
        return this.controller;
    }

    protected final WebClientSession<S> getStoredWebClientSession() {
        return ((Controller)this.getStoredController()).getStoredWebClientSession();
    }

    @Override
    protected final void resetControl() {
        this.rebuild();
    }
}

