/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.atomiccontrol.uploader;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.webgui.atomiccontrol.uploader.UploaderCssBuilder;
import ch.nolix.system.webgui.atomiccontrol.uploader.UploaderHtmlBuilder;
import ch.nolix.system.webgui.atomiccontrol.uploader.UploaderStyle;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.systemapi.webgui.atomiccontrol.uploaderapi.IUploader;
import ch.nolix.systemapi.webgui.atomiccontrol.uploaderapi.IUploaderStyle;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;

public final class Uploader
extends Control<IUploader, IUploaderStyle>
implements IUploader {
    private static final UploaderHtmlBuilder HTML_BUILDER = new UploaderHtmlBuilder();
    private static final UploaderCssBuilder CSS_BUILDER = new UploaderCssBuilder();
    private byte[] file;

    public Uploader() {
        this.reset();
    }

    @Override
    public byte[] getFile() {
        this.assertHasFile();
        return (byte[])this.file.clone();
    }

    @Override
    public Optional<String> getOptionalJavaScriptUserInputFunction() {
        return Optional.empty();
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredChildControls() {
        return ImmutableList.createEmpty();
    }

    @Override
    public String getUserInput() {
        return "";
    }

    @Override
    public boolean hasFile() {
        return this.file != null;
    }

    @Override
    public boolean hasRole(String role) {
        return false;
    }

    @Override
    public void internalSetFile(byte[] file) {
        Validator.assertThat(file).thatIsNamed("file").isNotNull();
        this.file = file;
    }

    @Override
    public void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
    }

    @Override
    public void runHtmlEvent(String htmlEvent) {
    }

    @Override
    public IUploader setUserInput(String userInput) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "setUserInput");
    }

    @Override
    protected IUploaderStyle createStyle() {
        return new UploaderStyle();
    }

    @Override
    protected IControlCssBuilder<IUploader, IUploaderStyle> getCssBuilder() {
        return CSS_BUILDER;
    }

    @Override
    protected IControlHtmlBuilder<IUploader> getHtmlBuilder() {
        return HTML_BUILDER;
    }

    @Override
    protected void resetControl() {
        this.removeFile();
    }

    private void assertHasFile() {
        if (!this.hasFile()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "file");
        }
    }

    private void removeFile() {
        this.file = null;
    }
}

