/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.atomiccontrol.validationlabel;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.generalexception.GeneralException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.webgui.atomiccontrol.validationlabel.ValidationLabelCssBuilder;
import ch.nolix.system.webgui.atomiccontrol.validationlabel.ValidationLabelHtmlBuilder;
import ch.nolix.system.webgui.atomiccontrol.validationlabel.ValidationLabelStyle;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.systemapi.webgui.atomiccontrol.validationlabelapi.IValidationLabel;
import ch.nolix.systemapi.webgui.atomiccontrol.validationlabelapi.IValidationLabelStyle;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.ControlState;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;

public final class ValidationLabel
extends Control<IValidationLabel, IValidationLabelStyle>
implements IValidationLabel {
    private static final String ERROR_HEADER = "Error";
    private final MutableOptionalValue<Throwable> error = new MutableOptionalValue<Throwable>("Error", this::showError, s -> GeneralException.withErrorMessage(s.getHeader()), e -> Node.withHeader(e.getMessage()));

    public ValidationLabel() {
        this.reset();
        this.setMinWidth(500);
    }

    @Override
    public void clear() {
        this.error.clear();
    }

    @Override
    public Throwable getError() {
        return (Throwable)this.error.getValue();
    }

    @Override
    public Optional<String> getOptionalJavaScriptUserInputFunction() {
        return Optional.empty();
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredChildControls() {
        return ImmutableList.createEmpty();
    }

    @Override
    public String getUserInput() {
        return "";
    }

    @Override
    public boolean hasRole(String role) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.error.isEmpty();
    }

    @Override
    public void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
    }

    @Override
    public void runHtmlEvent(String htmlEvent) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "runHtmlEvent");
    }

    @Override
    public ValidationLabel setUserInput(String userInput) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "setUserInput");
    }

    @Override
    public void showError(Throwable error) {
        this.error.setValue(error);
    }

    @Override
    protected ValidationLabelStyle createStyle() {
        return new ValidationLabelStyle();
    }

    @Override
    protected IControlCssBuilder<IValidationLabel, IValidationLabelStyle> getCssBuilder() {
        return new ValidationLabelCssBuilder();
    }

    @Override
    protected IControlHtmlBuilder<IValidationLabel> getHtmlBuilder() {
        return new ValidationLabelHtmlBuilder();
    }

    @Override
    protected void resetControl() {
        this.clear();
        ((IValidationLabelStyle)this.getStoredStyle()).setTextColorForState(ControlState.BASE, X11ColorCatalog.RED);
    }
}

