/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.controlstyle;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.element.multistateconfiguration.AbstractMultiStateConfiguration;
import ch.nolix.system.element.multistateconfiguration.CascadingProperty;
import ch.nolix.system.element.multistateconfiguration.NonCascadingProperty;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.gui.font.Font;
import ch.nolix.systemapi.gui.font.LineDecoration;
import ch.nolix.systemapi.webgui.controlstyle.IControlHeadStyle;
import ch.nolix.systemapi.webgui.main.ControlState;

abstract class AbstractControlHeadStyle<C extends IControlHeadStyle<C>>
extends AbstractMultiStateConfiguration<C, ControlState>
implements IControlHeadStyle<C> {
    public static final double DEFAULT_OPACITY = 1.0;
    public static final Font DEFAULT_FONT = Font.ARIAL;
    public static final boolean DEFAULT_BOLD_TEXT_FLAG = false;
    public static final int DEAULT_TEXT_SIZE = 20;
    public static final LineDecoration DEFAULT_TEXT_LINE_DECORATION = LineDecoration.UNDERLINE;
    public static final Color DEFAULT_TEXT_COLOR = X11ColorCatalog.BLACK;
    private final NonCascadingProperty<ControlState, Double> opacity = new NonCascadingProperty<ControlState, Double>("Opacity", ControlState.class, s -> this.getOpacityFromString(s.getSingleChildNodeHeader()), Node::withChildNode, this::setOpacityForState, 1.0);
    private final CascadingProperty<ControlState, Font> font = new CascadingProperty<ControlState, Font>("Font", ControlState.class, Font::fromSpecification, Node::fromEnum, DEFAULT_FONT);
    private final CascadingProperty<ControlState, Boolean> boldTextFlag = CascadingProperty.forBooleanWithNameAndStateClassAndDefaultValue("BoldText", ControlState.class, false);
    private final CascadingProperty<ControlState, Integer> textSize = CascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("TextSize", ControlState.class, this::setTextSizeForState, 20);
    private final CascadingProperty<ControlState, LineDecoration> textLineDecoration = new CascadingProperty<ControlState, LineDecoration>("TextLineDecoration", ControlState.class, LineDecoration::fromSpecification, Node::fromEnum, DEFAULT_TEXT_LINE_DECORATION);
    private final CascadingProperty<ControlState, IColor> textColor = new CascadingProperty<ControlState, Color>("TextColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_TEXT_COLOR);

    protected AbstractControlHeadStyle() {
        super(ControlState.BASE);
        this.textLineDecoration.setUndefined();
    }

    @Override
    public final <C2 extends IControlHeadStyle<C2>> void addChild(C2 controlStyle) {
        this.internalAddChild(controlStyle);
    }

    @Override
    public boolean definesTextLineDecorationForState(ControlState state) {
        return this.textLineDecoration.hasValueForState(state);
    }

    @Override
    public final boolean getBoldTextFlagWhenHasState(ControlState state) {
        return (Boolean)this.boldTextFlag.getValueWhenHasState(state);
    }

    @Override
    public final Font getFontWhenHasState(ControlState state) {
        return (Font)((Object)this.font.getValueWhenHasState(state));
    }

    @Override
    public final double getOpacityWhenHasState(ControlState state) {
        return (Double)this.opacity.getValueWhenHasState(state);
    }

    @Override
    public final IColor getTextColorWhenHasState(ControlState state) {
        return (IColor)this.textColor.getValueWhenHasState(state);
    }

    @Override
    public LineDecoration getTextLineDecorationWhenHasState(ControlState state) {
        return (LineDecoration)((Object)this.textLineDecoration.getValueWhenHasState(state));
    }

    @Override
    public final int getTextSizeWhenHasState(ControlState state) {
        return (Integer)this.textSize.getValueWhenHasState(state);
    }

    @Override
    public final void removeCustomBoldTextFlags() {
        this.boldTextFlag.setUndefined();
    }

    @Override
    public final void removeCustomFonts() {
        this.font.setUndefined();
    }

    @Override
    public final void removeCustomOpacities() {
        this.opacity.setUndefined();
    }

    @Override
    public final void removeCustomTextColors() {
        this.textColor.setUndefined();
    }

    @Override
    public void removeCustomTextLineDecorations() {
        this.textLineDecoration.setUndefined();
    }

    @Override
    public final void removeCustomTextSizes() {
        this.textSize.setUndefined();
    }

    @Override
    public final C setBoldTextFlagForState(ControlState state, boolean boldTextFlag) {
        this.boldTextFlag.setValueForState(state, boldTextFlag);
        return (C)((IControlHeadStyle)this.asConcrete());
    }

    @Override
    public final C setFontForState(ControlState state, Font font) {
        this.font.setValueForState(state, font);
        return (C)((IControlHeadStyle)this.asConcrete());
    }

    @Override
    public final C setOpacityForState(ControlState state, double opacity) {
        Validator.assertThat(opacity).thatIsNamed("opacity").isBetween(0.0, 1.0);
        this.opacity.setValueForState(state, opacity);
        return (C)((IControlHeadStyle)this.asConcrete());
    }

    @Override
    public final C setTextColorForState(ControlState state, IColor textColor) {
        this.textColor.setValueForState(state, textColor);
        return (C)((IControlHeadStyle)this.asConcrete());
    }

    @Override
    public C setTextLineDecorationForState(ControlState state, LineDecoration textLineDecoration) {
        this.textLineDecoration.setValueForState(state, textLineDecoration);
        return (C)((IControlHeadStyle)this.asConcrete());
    }

    @Override
    public final C setTextSizeForState(ControlState state, int textSize) {
        Validator.assertThat(textSize).thatIsNamed("text size").isPositive();
        this.textSize.setValueForState(state, textSize);
        return (C)((IControlHeadStyle)this.asConcrete());
    }

    private double getOpacityFromString(String string) {
        Validator.assertThat(string).thatIsNamed(String.class).isNotNull();
        if (!string.endsWith("%")) {
            return Double.valueOf(string);
        }
        return Double.valueOf(string.substring(0, string.length() - 1)) / 100.0;
    }
}

