/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.controlstyle;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.element.multistateconfiguration.ForwardingProperty;
import ch.nolix.system.element.multistateconfiguration.NonCascadingProperty;
import ch.nolix.system.element.relativevalue.AbsoluteOrRelativeInt;
import ch.nolix.system.element.relativevalue.AbsoluteOrRelativeIntValidator;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.gui.background.Background;
import ch.nolix.system.webgui.controlstyle.AbstractControlHeadStyle;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.element.multistateconfiguration.IMultiStateConfiguration;
import ch.nolix.systemapi.element.relativevalue.IAbsoluteOrRelativeInt;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.graphic.color.IColorGradient;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.graphic.image.ImageApplication;
import ch.nolix.systemapi.gui.background.IBackground;
import ch.nolix.systemapi.webgui.controlstyle.IControlStyle;
import ch.nolix.systemapi.webgui.main.ControlState;

public abstract class AbstractControlStyle<S extends IControlStyle<S> & IMultiStateConfiguration<S, ControlState>>
extends AbstractControlHeadStyle<S>
implements IControlStyle<S> {
    public static final int DEFAULT_CORNER_RADIUS = 0;
    public static final int DEFAULT_BORDER_THICKNESS = 0;
    public static final IColor DEFAULT_BORDER_COLOR = X11ColorCatalog.BLACK;
    public static final IBackground DEFAULT_BACKGROUND = Background.TRANSPARENT_BACKGROUND;
    public static final int DEFAULT_PADDING = 0;
    private static final String WIDTH_HEADER = "Width";
    private static final String HEIGHT_HEADER = "Height";
    private static final String CORNER_RADIUS_HEADER = "CornerRadius";
    private static final String LEFT_BORDER_THICKNESS_HEADER = "LeftBorderThickness";
    private static final String RIGHT_BORDER_THICKNESS_HEADER = "RightBorderThickness";
    private static final String TOP_BORDER_THICKNESS_HEADER = "TopBorderThickness";
    private static final String BOTTOM_BORDER_THICKNESS_HEADER = "BottomBorderThickness";
    private static final String LEFT_BORDER_COLOR_HEADER = "LeftBorderColor";
    private static final String RIGHT_BORDER_COLOR_HEADER = "RightBorderColor";
    private static final String TOP_BORDER_COLOR_HEADER = "TopBorderColor";
    private static final String BOTTOM_BORDER_COLOR_HEADER = "BottomBorderColor";
    private static final String BACKGROUND_HEADER = "Background";
    private static final String LEFT_PADDING_HEADER = "LeftPadding";
    private static final String RIGHT_PADDING_HEADER = "RightPadding";
    private static final String TOP_PADDING_HEADER = "TopPadding";
    private static final String BOTTOM_PADDING_HEADER = "BottomPadding";
    private static final String BORDER_COLOR_HEADER = "BorderColor";
    private static final String BORDER_THICKNESS_HEADER = "BorderThickness";
    private static final String PADDING_HEADER = "Padding";
    private final NonCascadingProperty<ControlState, IAbsoluteOrRelativeInt> width = new NonCascadingProperty<ControlState, AbsoluteOrRelativeInt>("Width", ControlState.class, AbsoluteOrRelativeInt::fromSpecification, IElement::getSpecification, this::setWidthForState, AbsoluteOrRelativeInt.withIntValue(100));
    private final NonCascadingProperty<ControlState, IAbsoluteOrRelativeInt> height = new NonCascadingProperty<ControlState, AbsoluteOrRelativeInt>("Height", ControlState.class, AbsoluteOrRelativeInt::fromSpecification, IElement::getSpecification, this::setHeightForState, AbsoluteOrRelativeInt.withIntValue(100));
    private final NonCascadingProperty<ControlState, Integer> cornerRadius = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("CornerRadius", ControlState.class, (controlState, n) -> this.setCornerRadiusForState((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> leftBorderThickness = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("LeftBorderThickness", ControlState.class, (controlState, n) -> this.setLeftBorderThicknessForState((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> rightBorderThickness = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("RightBorderThickness", ControlState.class, (controlState, n) -> this.setRightBorderThicknessForState((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> topBorderThickness = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("TopBorderThickness", ControlState.class, (controlState, n) -> this.setTopBorderThicknessForState((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> bottomBorderThickness = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("BottomBorderThickness", ControlState.class, (controlState, n) -> this.setBottomBorderThicknessForState((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, IColor> leftBorderColor = new NonCascadingProperty<ControlState, IColor>("LeftBorderColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_BORDER_COLOR);
    private final NonCascadingProperty<ControlState, IColor> rightBorderColor = new NonCascadingProperty<ControlState, IColor>("RightBorderColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_BORDER_COLOR);
    private final NonCascadingProperty<ControlState, IColor> topBorderColor = new NonCascadingProperty<ControlState, IColor>("TopBorderColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_BORDER_COLOR);
    private final NonCascadingProperty<ControlState, IColor> bottomBorderColor = new NonCascadingProperty<ControlState, IColor>("BottomBorderColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, DEFAULT_BORDER_COLOR);
    private final NonCascadingProperty<ControlState, IBackground> background = new NonCascadingProperty<ControlState, IBackground>("Background", ControlState.class, Background::fromSpecification, IElement::getSpecification, DEFAULT_BACKGROUND);
    private final NonCascadingProperty<ControlState, Integer> leftPadding = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("LeftPadding", ControlState.class, (controlState, n) -> this.setLeftPaddingForState((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> rightPadding = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("RightPadding", ControlState.class, (controlState, n) -> this.setRightPaddingForState((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> topPadding = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("TopPadding", ControlState.class, (controlState, n) -> this.setTopPaddingForState((ControlState)((Object)controlState), (int)n), 0);
    private final NonCascadingProperty<ControlState, Integer> bottomPadding = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("BottomPadding", ControlState.class, (controlState, n) -> this.setBottomPaddingForState((ControlState)((Object)controlState), (int)n), 0);
    private final ForwardingProperty<ControlState, Integer> borderThickness = ForwardingProperty.withNameAndForProperty("BorderThickness", this.leftBorderThickness, this.rightBorderThickness, this.topBorderThickness, this.bottomBorderThickness);
    private final ForwardingProperty<ControlState, IColor> borderColor = ForwardingProperty.withNameAndForProperty("BorderColor", this.leftBorderColor, this.rightBorderColor, this.topBorderColor, this.bottomBorderColor);
    private final ForwardingProperty<ControlState, Integer> padding = ForwardingProperty.withNameAndForProperty("Padding", this.leftPadding, this.rightPadding, this.topPadding, this.bottomPadding);

    @Override
    public final boolean definesHeightForState(ControlState state) {
        return this.height.hasValueForState(state);
    }

    @Override
    public final boolean definesWidthForState(ControlState state) {
        return this.width.hasValueForState(state);
    }

    @Override
    public final IBackground getBackgroundWhenHasState(ControlState state) {
        return (IBackground)this.background.getValueWhenHasState(state);
    }

    @Override
    public final IColor getBottomBorderColorWhenHasState(ControlState state) {
        return (IColor)this.bottomBorderColor.getValueWhenHasState(state);
    }

    @Override
    public final int getBottomBorderThicknessWhenHasState(ControlState state) {
        return (Integer)this.bottomBorderThickness.getValueWhenHasState(state);
    }

    @Override
    public final int getBottomPaddingWhenHasState(ControlState state) {
        return (Integer)this.bottomPadding.getValueWhenHasState(state);
    }

    @Override
    public int getCornerRadiusWhenHasState(ControlState state) {
        return (Integer)this.cornerRadius.getValueWhenHasState(state);
    }

    @Override
    public final IColor getLeftBorderColorWhenHasState(ControlState state) {
        return (IColor)this.leftBorderColor.getValueWhenHasState(state);
    }

    @Override
    public final int getLeftBorderThicknessWhenHasState(ControlState state) {
        return (Integer)this.leftBorderThickness.getValueWhenHasState(state);
    }

    @Override
    public final IAbsoluteOrRelativeInt getHeightForState(ControlState state) {
        return (IAbsoluteOrRelativeInt)this.height.getValueWhenHasState(state);
    }

    @Override
    public final int getLeftPaddingWhenHasState(ControlState state) {
        return (Integer)this.leftPadding.getValueWhenHasState(state);
    }

    @Override
    public final IColor getRightBorderColorWhenHasState(ControlState state) {
        return (IColor)this.rightBorderColor.getValueWhenHasState(state);
    }

    @Override
    public final int getRightBorderThicknessWhenHasState(ControlState state) {
        return (Integer)this.rightBorderThickness.getValueWhenHasState(state);
    }

    @Override
    public final int getRightPaddingWhenHasState(ControlState state) {
        return (Integer)this.rightPadding.getValueWhenHasState(state);
    }

    @Override
    public final IColor getTopBorderColorWhenHasState(ControlState state) {
        return (IColor)this.topBorderColor.getValueWhenHasState(state);
    }

    @Override
    public final int getTopBorderThicknessWhenHasState(ControlState state) {
        return (Integer)this.topBorderThickness.getValueWhenHasState(state);
    }

    @Override
    public final int getTopPaddingWhenHasState(ControlState state) {
        return (Integer)this.topPadding.getValueWhenHasState(state);
    }

    @Override
    public final IAbsoluteOrRelativeInt getWidthForState(ControlState state) {
        return (IAbsoluteOrRelativeInt)this.width.getValueWhenHasState(state);
    }

    @Override
    public final void removeCustomBackgrounds() {
        this.background.setUndefined();
    }

    @Override
    public final void removeCustomBorderColors() {
        this.borderColor.setUndefined();
    }

    @Override
    public final void removeCustomBorderThicknesses() {
        this.removeCustomLeftBorderColors();
        this.removeCustomRightBorderColors();
        this.removeCustomTopBorderColors();
        this.removeCustomBottomBorderColors();
    }

    @Override
    public final void removeCustomBottomBorderColors() {
        this.bottomBorderColor.setUndefined();
    }

    @Override
    public final void removeCustomBottomBorderThicknesses() {
        this.bottomBorderThickness.setUndefined();
    }

    @Override
    public final void removeCustomBottomPaddings() {
        this.bottomPadding.setUndefined();
    }

    @Override
    public void removeCustomCornerRadiuses() {
        this.cornerRadius.setUndefined();
    }

    @Override
    public final void removeCustomHeights() {
        this.height.setUndefined();
    }

    @Override
    public final void removeCustomLeftBorderColors() {
        this.leftBorderColor.setUndefined();
    }

    @Override
    public final void removeCustomLeftBorderThicknesses() {
        this.leftBorderThickness.setUndefined();
    }

    @Override
    public final void removeCustomLeftPaddings() {
        this.leftPadding.setUndefined();
    }

    @Override
    public final void removeCustomPaddings() {
        this.removeCustomLeftPaddings();
        this.removeCustomRightPaddings();
        this.removeCustomTopPaddings();
        this.removeCustomBottomPaddings();
    }

    @Override
    public final void removeCustomRightBorderColors() {
        this.rightBorderColor.setUndefined();
    }

    @Override
    public final void removeCustomRightBorderThicknesses() {
        this.rightBorderThickness.setUndefined();
    }

    @Override
    public final void removeCustomRightPaddings() {
        this.rightPadding.setUndefined();
    }

    @Override
    public final void removeCustomTopBorderColors() {
        this.topBorderColor.setUndefined();
    }

    @Override
    public final void removeCustomTopBorderThicknesses() {
        this.topBorderThickness.setUndefined();
    }

    @Override
    public final void removeCustomTopPaddings() {
        this.topPadding.setUndefined();
    }

    @Override
    public final void removeCustomWidths() {
        this.width.setUndefined();
    }

    @Override
    public final S setBackgroundColorForState(ControlState state, IColor backgroundColor) {
        return (S)this.setBackgroundForState(state, Background.withColor(backgroundColor));
    }

    @Override
    public final S setBackgroundColorGradientForState(ControlState state, IColorGradient backgroundColorGradient) {
        return (S)this.setBackgroundForState(state, Background.withColorGradient(backgroundColorGradient));
    }

    @Override
    public final S setBackgroundForState(ControlState state, IBackground background) {
        this.background.setValueForState(state, background);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setBackgroundImageForState(ControlState state, IImage backgroundImage, ImageApplication imageApplication) {
        return (S)this.setBackgroundForState(state, Background.withImageAndImageApplication(backgroundImage, imageApplication));
    }

    @Override
    public final S setBorderColorForState(ControlState state, IColor borderColor) {
        this.borderColor.setValueForState(state, borderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setBorderThicknessForState(ControlState state, int borderThickness) {
        this.borderThickness.setValueForState(state, borderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setBottomBorderColorForState(ControlState state, IColor bottomBorderColor) {
        this.bottomBorderColor.setValueForState(state, bottomBorderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setBottomBorderThicknessForState(ControlState state, int bottomBorderThickness) {
        Validator.assertThat(bottomBorderThickness).thatIsNamed("bottom border thickness").isNotNegative();
        this.bottomBorderThickness.setValueForState(state, bottomBorderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setBottomPaddingForState(ControlState state, int bottomPadding) {
        Validator.assertThat(bottomPadding).thatIsNamed("bottom padding").isNotNegative();
        this.bottomPadding.setValueForState(state, bottomPadding);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public S setCornerRadiusForState(ControlState state, int cornerRadius) {
        Validator.assertThat(cornerRadius).thatIsNamed("corner radius").isNotNegative();
        this.cornerRadius.setValueForState(state, cornerRadius);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setHeightForState(ControlState state, int height) {
        this.setHeightForState(state, AbsoluteOrRelativeInt.withIntValue(height));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setHeightInPercentOfViewAreaForState(ControlState state, double heightInPercentOfViewAreaHeight) {
        this.setHeightForState(state, AbsoluteOrRelativeInt.withPercentage(heightInPercentOfViewAreaHeight));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setLeftBorderColorForState(ControlState state, IColor leftBorderColor) {
        this.leftBorderColor.setValueForState(state, leftBorderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setLeftBorderThicknessForState(ControlState state, int leftBorderThickness) {
        Validator.assertThat(leftBorderThickness).thatIsNamed("left border thickness").isNotNegative();
        this.leftBorderThickness.setValueForState(state, leftBorderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setLeftPaddingForState(ControlState state, int leftPadding) {
        Validator.assertThat(leftPadding).thatIsNamed("left padding").isNotNegative();
        this.leftPadding.setValueForState(state, leftPadding);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setPaddingForState(ControlState state, int padding) {
        this.padding.setValueForState(state, padding);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setRightBorderColorForState(ControlState state, IColor rightBorderColor) {
        this.rightBorderColor.setValueForState(state, rightBorderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setRightBorderThicknessForState(ControlState state, int rightBorderThickness) {
        Validator.assertThat(rightBorderThickness).thatIsNamed("right border thickness").isNotNegative();
        this.rightBorderThickness.setValueForState(state, rightBorderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setRightPaddingForState(ControlState state, int rightPadding) {
        Validator.assertThat(rightPadding).thatIsNamed("right padding").isNotNegative();
        this.rightPadding.setValueForState(state, rightPadding);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setTopBorderColorForState(ControlState state, IColor topBorderColor) {
        this.topBorderColor.setValueForState(state, topBorderColor);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setTopBorderThicknessForState(ControlState state, int topBorderThickness) {
        Validator.assertThat(topBorderThickness).thatIsNamed("top border thickness").isNotNegative();
        this.topBorderThickness.setValueForState(state, topBorderThickness);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setTopPaddingForState(ControlState state, int topPadding) {
        Validator.assertThat(topPadding).thatIsNamed("top padding").isNotNegative();
        this.topPadding.setValueForState(state, topPadding);
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public final S setWidthForState(ControlState state, int width) {
        this.setWidthForState(state, AbsoluteOrRelativeInt.withIntValue(width));
        return (S)((IControlStyle)this.asConcrete());
    }

    @Override
    public S setWidthInPercentOfViewAreaWidthForState(ControlState state, double widthInPercentOfViewAreaWidth) {
        this.setWidthForState(state, AbsoluteOrRelativeInt.withPercentage(widthInPercentOfViewAreaWidth));
        return (S)((IControlStyle)this.asConcrete());
    }

    private void setHeightForState(ControlState state, IAbsoluteOrRelativeInt height) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(height);
        this.height.setValueForState(state, height);
    }

    private void setWidthForState(ControlState state, IAbsoluteOrRelativeInt width) {
        AbsoluteOrRelativeIntValidator.assertIsPositive(width);
        this.width.setValueForState(state, width);
    }
}

