/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.web.css.ICss;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.element.property.MultiValueExtractor;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.graphic.image.Image;
import ch.nolix.system.gui.background.Background;
import ch.nolix.system.gui.frontend.LocalFrontEndReader;
import ch.nolix.system.gui.frontend.LocalFrontEndWriter;
import ch.nolix.system.gui.iconresource.IconCatalog;
import ch.nolix.system.style.stylable.AbstractStyleElement;
import ch.nolix.system.webgui.main.Layer;
import ch.nolix.system.webgui.main.LayerStack;
import ch.nolix.system.webgui.main.WebGuiCssBuilder;
import ch.nolix.system.webgui.main.WebGuiHtmlBuilder;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.graphic.color.IColorGradient;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.graphic.image.ImageApplication;
import ch.nolix.systemapi.gui.background.BackgroundType;
import ch.nolix.systemapi.gui.background.IBackground;
import ch.nolix.systemapi.gui.frontend.IFrontEndReader;
import ch.nolix.systemapi.gui.frontend.IFrontEndWriter;
import ch.nolix.systemapi.style.stylable.IStylableElement;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import ch.nolix.systemapi.webgui.main.ILayer;
import ch.nolix.systemapi.webgui.main.ILayerStack;
import ch.nolix.systemapi.webgui.main.IWebGui;
import java.util.Optional;

public final class WebGui
extends AbstractStyleElement<WebGui>
implements IWebGui<WebGui> {
    public static final String DEFAULT_TITLE = "GUI";
    public static final Image DEFAULT_ICON = IconCatalog.NOLIX_ICON;
    public static final Color DEFAULT_BACKGROUND_COLOR = X11ColorCatalog.WHITE;
    private static final String TITLE_HEADER = "Title";
    private static final String ICON_HEADER = "Icon";
    private static final String BACKGROUND_HEADER = "Background";
    private static final String LAYER_HEADER = "Layer";
    private static final WebGuiHtmlBuilder WEB_GUI_HTML_BUILDER = new WebGuiHtmlBuilder();
    private static final WebGuiCssBuilder WEB_GUI_CSS_BUILDER = new WebGuiCssBuilder();
    private final MutableValue<String> title = new MutableValue<String>("Title", "GUI", this::setTitle, INode::getSingleChildNodeHeader, string -> Node.withChildNode(string, new String[0]));
    private final MutableValue<Image> icon = new MutableValue<Image>("Icon", DEFAULT_ICON, this::setIcon, Image::fromSpecification, AbstractElement::getSpecification);
    private final MutableOptionalValue<IBackground> background = new MutableOptionalValue<IBackground>("Background", this::setBackground, Background::fromSpecification, IElement::getSpecification);
    private final MultiValueExtractor<ILayer<?>> layerExtractor = new MultiValueExtractor<ILayer>("Layer", iLayer -> this.pushLayer((ILayer)iLayer), this::getStoredLayers, Layer::fromSpecification, IElement::getSpecification);
    private final ILayerStack layerStack = LayerStack.forWebGui(this);
    private IFrontEndReader frontEndReader = new LocalFrontEndReader();
    private IFrontEndWriter frontEndWriter = new LocalFrontEndWriter();

    public WebGui() {
        this.reset();
        this.setBackgroundColor(DEFAULT_BACKGROUND_COLOR);
    }

    @Override
    public boolean containsControl(IControl<?, ?> control) {
        return this.layerStack.containsControl(control);
    }

    @Override
    public void clear() {
        this.layerStack.clear();
    }

    @Override
    public IFrontEndReader fromFrontEnd() {
        return this.frontEndReader;
    }

    @Override
    public IBackground getBackground() {
        return (IBackground)this.background.getValue();
    }

    @Override
    public IColor getBackgroundColor() {
        return this.getBackground().getColor();
    }

    @Override
    public IColorGradient getBackgroundColorGradient() {
        return this.getBackground().getColorGradient();
    }

    @Override
    public IImage getBackgroundImage() {
        return this.getBackground().getImage();
    }

    @Override
    public ImageApplication getBackgroundImageApplication() {
        return this.getBackground().getImageApplication();
    }

    @Override
    public BackgroundType getBackgroundType() {
        return this.getBackground().getType();
    }

    @Override
    public ICss getCss() {
        return WEB_GUI_CSS_BUILDER.createCssForWebGui(this);
    }

    @Override
    public IHtmlElement getHtml() {
        return WEB_GUI_HTML_BUILDER.createHtmlForWebGui(this);
    }

    @Override
    public IImage getIcon() {
        return (IImage)this.icon.getValue();
    }

    @Override
    public IContainer<IHtmlElementEvent> getHtmlElementEventRegistrations() {
        LinkedList<IHtmlElementEvent> htmlElementEventRegistrations = LinkedList.createEmpty();
        this.registerHtmlElementEventsAt(htmlElementEventRegistrations);
        return htmlElementEventRegistrations;
    }

    @Override
    public int getLayerCount() {
        return this.layerStack.getLayerCount();
    }

    @Override
    public Optional<IControl<?, ?>> getOptionalStoredControlByInternalId(String internalId) {
        return this.layerStack.getOptionalStoredControlByInternalId(internalId);
    }

    @Override
    public IContainer<? extends IStylableElement<?>> getStoredChildStylableElements() {
        return this.getStoredLayers();
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredControls() {
        return this.layerStack.getStoredControls();
    }

    @Override
    public IContainer<ILayer<?>> getStoredLayers() {
        return this.layerStack.getStoredLayers();
    }

    @Override
    public ILayer<?> getStoredTopLayer() {
        return this.layerStack.getStoredTopLayer();
    }

    @Override
    public String getTitle() {
        return (String)this.title.getValue();
    }

    @Override
    public boolean hasBackground() {
        return this.background.containsAny();
    }

    @Override
    public boolean hasRemoveLayerAction() {
        return this.layerStack.hasRemoveLayerAction();
    }

    @Override
    public boolean hasRole(String role) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.layerStack.isEmpty();
    }

    @Override
    public boolean isRootGui() {
        return false;
    }

    @Override
    public IFrontEndWriter onFrontEnd() {
        return this.frontEndWriter;
    }

    @Override
    public WebGui pushLayer(ILayer<?> layer) {
        this.layerStack.pushLayer(layer);
        return this;
    }

    @Override
    public WebGui pushLayerWithRootControl(IControl<?, ?> rootControl) {
        this.layerStack.pushLayerWithRootControl(rootControl);
        return this;
    }

    @Override
    public void removeBackground() {
        this.background.clear();
    }

    @Override
    public void removeLayer(ILayer<?> layer) {
        this.layerStack.removeLayer(layer);
    }

    public WebGui setBackground(IBackground background) {
        this.background.setValue(background);
        return this;
    }

    @Override
    public WebGui setBackgroundColor(IColor backgroundColor) {
        return this.setBackground(Background.withColor(backgroundColor));
    }

    @Override
    public WebGui setBackgroundColorGradient(IColorGradient backgroundColorGradient) {
        return this.setBackground(Background.withColorGradient(backgroundColorGradient));
    }

    @Override
    public WebGui setBackgroundImage(IImage backgroundImage) {
        return this.setBackground(Background.withImage(backgroundImage));
    }

    @Override
    public WebGui setBackgroundImage(IImage backgroundImage, ImageApplication imageApplication) {
        return this.setBackground(Background.withImageAndImageApplication(backgroundImage, imageApplication));
    }

    @Override
    public WebGui setFrontEndReaderAndFrontEndWriter(IFrontEndReader frontEndReader, IFrontEndWriter frontEndWriter) {
        Validator.assertThat(frontEndReader).thatIsNamed(IFrontEndReader.class).isNotNull();
        Validator.assertThat(frontEndWriter).thatIsNamed(IFrontEndWriter.class).isNotNull();
        this.frontEndReader = frontEndReader;
        this.frontEndWriter = frontEndWriter;
        return this;
    }

    @Override
    public WebGui setIcon(IImage icon) {
        this.icon.setValue(Image.fromAnyImage(icon));
        return this;
    }

    @Override
    public WebGui setRemoveLayerAction(Runnable removeLayerAction) {
        this.layerStack.setRemoveLayerAction(removeLayerAction);
        return this;
    }

    @Override
    public WebGui setTitle(String title) {
        Validator.assertThat(title).thatIsNamed("title").isNotBlank();
        this.title.setValue(title);
        return this;
    }

    @Override
    protected void resetConfigurationElement() {
        this.setTitle(DEFAULT_TITLE);
        this.setIcon(DEFAULT_ICON);
        this.clear();
    }

    @Override
    protected void resetStyle() {
        if (this.hasBackground() && this.getBackground().getType() != BackgroundType.IMAGE) {
            this.setBackgroundColor(DEFAULT_BACKGROUND_COLOR);
        }
    }

    private void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> htmlElementEventRegistrations) {
        for (IControl iControl : this.getStoredControls()) {
            iControl.registerHtmlElementEventsAt(htmlElementEventRegistrations);
        }
    }
}

