/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.systemapi.gui.model;

import ch.nolix.coreapi.document.node.INode;
import java.awt.Cursor;
import java.util.Locale;

public enum CursorIcon {
    ARROW,
    CROSS,
    EDIT,
    HAND,
    MOVE,
    WAIT;


    public static CursorIcon fromSpecification(INode<?> specification) {
        return CursorIcon.valueOf(specification.getSingleChildNodeHeader().toUpperCase(Locale.ENGLISH));
    }

    public String toCssValue() {
        return switch (this) {
            case ARROW -> "default";
            case CROSS -> "crosshair";
            case EDIT -> "text";
            case HAND -> "pointer";
            case MOVE -> "move";
            case WAIT -> "wait";
            default -> throw new IllegalArgumentException("The current CursorIcon does not represent a CSS value.");
        };
    }

    public Cursor toCursor() {
        return switch (this) {
            case ARROW -> new Cursor(0);
            case CROSS -> new Cursor(1);
            case EDIT -> new Cursor(2);
            case HAND -> new Cursor(12);
            case MOVE -> new Cursor(13);
            case WAIT -> new Cursor(3);
            default -> new Cursor(0);
        };
    }
}

