/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.bigdecimalmath;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.tech.math.bigdecimalmath.AbstractSequence;
import ch.nolix.techapi.math.bigdecimalmath.IComplexNumber;
import java.math.BigDecimal;
import java.util.function.IntFunction;

public final class ComplexExplicitSequence
extends AbstractSequence<IComplexNumber> {
    private final IntFunction<IComplexNumber> valueFunction;

    public ComplexExplicitSequence(IntFunction<IComplexNumber> valueFunction) {
        Validator.assertThat(valueFunction).thatIsNamed("value function").isNotNull();
        this.valueFunction = valueFunction;
    }

    @Override
    protected BigDecimal calculateSquaredMagnitudeForValue(IComplexNumber value) {
        return value.getSquaredMagnitude();
    }

    @Override
    protected IComplexNumber calculateValue(int index) {
        return this.valueFunction.apply(index);
    }
}

