/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.template.graphic.texture;

import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.image.MutableImage;
import ch.nolix.systemapi.graphic.image.IImage;

public final class TextureCreator {
    private TextureCreator() {
    }

    public static IImage createConcreteTexture() {
        MutableImage texture = MutableImage.withWidthAndHeightAndWhiteColor(16, 16);
        Color color1 = Color.fromLong(0x808080L);
        Color color2 = Color.fromLong(0xC0C0C0L);
        Color color3 = Color.fromLong(0xA0A0A0L);
        int x = 1;
        while (x <= texture.getWidth()) {
            int y = 1;
            while (y <= texture.getHeight()) {
                if ((y + 1) * (x * y - y % 3) % 7 == (x * y - x % 5 + y % 2) % 11) {
                    texture.setPixel(x, y, color1);
                } else if ((x * x + y * y) % 11 == x * y % 13) {
                    texture.setPixel(x, y, color2);
                } else {
                    texture.setPixel(x, y, color3);
                }
                ++y;
            }
            ++x;
        }
        return texture.toImmutableImage();
    }

    public static IImage createFirWoodTexture() {
        MutableImage texture = MutableImage.withWidthAndHeightAndWhiteColor(16, 16);
        Color mainColor = Color.fromLong(14733488L);
        Color darkerStripeColor = Color.fromLong(12628096L);
        Color knotholeColor = Color.fromLong(8417376L);
        int x = 1;
        while (x <= texture.getWidth()) {
            int y = 1;
            while (y <= texture.getHeight()) {
                if ((x + y % 2) % 10 == 2 && y % 5 == 0) {
                    texture.setPixel(x, y, knotholeColor);
                } else if ((y + x / (10 + y / 10)) % (3 + y / 10) == 0) {
                    texture.setPixel(x, y, darkerStripeColor);
                } else {
                    texture.setPixel(x, y, mainColor);
                }
                ++y;
            }
            ++x;
        }
        return texture.toImmutableImage();
    }

    public static IImage createJuteTexture() {
        MutableImage texture = MutableImage.withWidthAndHeightAndWhiteColor(16, 16);
        Color color1 = Color.fromLong(0xC0C0A0L);
        Color color2 = Color.fromLong(0x808060L);
        Color color3 = Color.fromLong(0xA0A080L);
        int x = 1;
        while (x <= texture.getWidth()) {
            int y = 1;
            while (y <= texture.getHeight()) {
                if (x * y % 3 == (x + y) % 2) {
                    texture.setPixel(x, y, color1);
                } else if ((x * x + y * y) % 5 == x * y % 7) {
                    texture.setPixel(x, y, color2);
                } else {
                    texture.setPixel(x, y, color3);
                }
                ++y;
            }
            ++x;
        }
        return texture.toImmutableImage();
    }

    public static IImage createParchmentTexture() {
        MutableImage texture = MutableImage.withWidthAndHeightAndWhiteColor(16, 16);
        Color color1 = Color.fromLong(0xEFEFCFL);
        Color color2 = Color.fromLong(13610831L);
        Color color3 = Color.fromLong(5189376L);
        int x = 1;
        while (x <= texture.getWidth()) {
            int y = 1;
            while (y <= texture.getHeight()) {
                if ((x + (x - y) % 3) % 4 != 0 && y * y % x < 5) {
                    texture.setPixel(x, y, color1);
                } else if (x * x % y != 0) {
                    texture.setPixel(x, y, color2);
                } else {
                    texture.setPixel(x, y, color3);
                }
                ++y;
            }
            ++x;
        }
        return texture.toImmutableImage();
    }

    public static IImage createWhiteMarbleTexture() {
        MutableImage texture = MutableImage.withWidthAndHeightAndWhiteColor(16, 16);
        Color color1 = Color.fromLong(0x282820L);
        Color color2 = Color.fromLong(0x888880L);
        Color color3 = Color.fromLong(0xF8F8F0L);
        int x = 1;
        while (x <= texture.getWidth()) {
            int y = 1;
            while (y <= texture.getHeight()) {
                if (x == y / 2 + x / 5 || x == y / 4 + x / 4 + 8 || x % 11 == (y - 2) % 7) {
                    texture.setPixel(x, y, color1);
                } else if ((texture.getWidth() - x) % 5 == y % 3) {
                    texture.setPixel(x, y, color2);
                } else {
                    texture.setPixel(x, y, color3);
                }
                ++y;
            }
            ++x;
        }
        return texture.toImmutableImage();
    }
}

