/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.commontypetool.stringtool;

import ch.nolix.coreapi.commontypetool.charactertool.CharacterType;

public final class PascalCaseTransformer {
    public String toPascalCase(String string) {
        if (string.isEmpty()) {
            return "";
        }
        return this.toPascalCaseWhenStringIsNotEmpty(string);
    }

    private String toPascalCaseWhenStringIsNotEmpty(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char firstCharacter = string.charAt(0);
        CharacterType firstCharacterType = CharacterType.ofCharacter(firstCharacter);
        switch (firstCharacterType) {
            case LOWER_CASE_LETTER: {
                stringBuilder.append(Character.toUpperCase(firstCharacter));
                break;
            }
            default: {
                stringBuilder.append(firstCharacter);
            }
        }
        char previousCharacter = firstCharacter;
        CharacterType previousCharacterType = firstCharacterType;
        int i = 1;
        while (i < string.length()) {
            char character = string.charAt(i);
            CharacterType characterType = CharacterType.ofCharacter(character);
            switch (characterType) {
                case LOWER_CASE_LETTER: {
                    stringBuilder.append(this.getTargetCharacterWhenSourceCharacterIsNotAtBeginAndLowerCaseLetter(character, previousCharacter, previousCharacterType));
                    break;
                }
                case UPPER_CASE_LETTER: {
                    stringBuilder.append(this.getTargetCharacterWhenSourceCharacterIsNotAtBeginAndUpperCaseLetter(character, previousCharacter, previousCharacterType));
                    break;
                }
                case NUMBER: {
                    stringBuilder.append(character);
                    break;
                }
                case OTHER: {
                    if (character == '_') break;
                    stringBuilder.append(character);
                }
            }
            previousCharacter = character;
            previousCharacterType = characterType;
            ++i;
        }
        return stringBuilder.toString();
    }

    private char getTargetCharacterWhenSourceCharacterIsNotAtBeginAndLowerCaseLetter(char sourceCharacter, char previousCharacter, CharacterType previousCharacterType) {
        if (previousCharacterType == CharacterType.NUMBER || previousCharacter == '_' || previousCharacterType == CharacterType.OTHER) {
            return Character.toUpperCase(sourceCharacter);
        }
        return sourceCharacter;
    }

    private char getTargetCharacterWhenSourceCharacterIsNotAtBeginAndUpperCaseLetter(char sourceCharacter, char previousCharacter, CharacterType previousCharacterType) {
        if (previousCharacterType == CharacterType.LOWER_CASE_LETTER || previousCharacterType == CharacterType.NUMBER || previousCharacter == '_' || previousCharacterType == CharacterType.OTHER) {
            return sourceCharacter;
        }
        return Character.toLowerCase(sourceCharacter);
    }
}

