/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.commontypetool.iteratorvalidator.IteratorValidator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class ArrayListIterator<E>
implements CopyableIterator<E> {
    private static final IteratorValidator ITERATOR_VALIDATOR = new IteratorValidator();
    private final E[] parentArray;
    private final int maxNextIndex;
    private int nextIndex;

    private ArrayListIterator(E[] parrentArray, int maxNextIndex) {
        Validator.assertThat(parrentArray).thatIsNamed("parent array").isNotNull();
        Validator.assertThat(maxNextIndex).thatIsNamed("max next index").isNotNegative();
        this.parentArray = parrentArray;
        this.maxNextIndex = maxNextIndex;
        this.nextIndex = 0;
    }

    private ArrayListIterator(E[] parrentArray, int startIndex, int maxNexIndex) {
        Validator.assertThat(parrentArray).thatIsNamed("parent array").isNotNull();
        Validator.assertThat(startIndex).thatIsNamed("start index").isNotNegative();
        Validator.assertThat(maxNexIndex).thatIsNamed("max next index").isBiggerThanOrEquals(startIndex);
        this.parentArray = parrentArray;
        this.maxNextIndex = maxNexIndex;
        this.nextIndex = startIndex;
    }

    public static <E2> ArrayListIterator<E2> forArrayAndMaxNextIndex(E2[] array, int maxNextIndex) {
        return new ArrayListIterator<E2>(array, maxNextIndex);
    }

    public static <E2> ArrayListIterator<E2> forArrayAndStartIndexAndMaxNextIndex(E2[] array, int startIndex, int maxIndex) {
        return new ArrayListIterator<E2>(array, startIndex, maxIndex);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return ArrayListIterator.forArrayAndStartIndexAndMaxNextIndex(this.parentArray, this.nextIndex, this.maxNextIndex);
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.maxNextIndex;
    }

    @Override
    public E next() {
        this.assertHasNext();
        return this.nextWhenHasNext();
    }

    private void assertHasNext() {
        ITERATOR_VALIDATOR.assertHasNext(this);
    }

    private E nextWhenHasNext() {
        E element = this.parentArray[this.nextIndex];
        ++this.nextIndex;
        return element;
    }
}

