/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.Iterator;

final class IntervallContainerViewIterator<E>
implements CopyableIterator<E> {
    private final IContainer<E> parentContainer;
    private final int endIndex;
    private final Iterator<E> iterator;
    private int currentIndex;

    public IntervallContainerViewIterator(IContainer<E> parentContainer, int startIndex, int endIndex) {
        Validator.assertThat(parentContainer).thatIsNamed("parent container").isNotNull();
        Validator.assertThat(startIndex).thatIsNamed("start index").isPositive();
        Validator.assertThat(endIndex).thatIsNamed("end index").isPositive();
        Validator.assertThat(endIndex).thatIsNamed("end index").isBiggerThanOrEquals(startIndex);
        this.parentContainer = parentContainer;
        this.endIndex = endIndex;
        this.currentIndex = startIndex;
        this.iterator = parentContainer.iterator();
        int i = 1;
        while (i < startIndex) {
            this.iterator.next();
            ++i;
        }
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return new IntervallContainerViewIterator<E>(this.parentContainer, this.currentIndex, this.endIndex);
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex <= this.endIndex;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next element");
        }
        ++this.currentIndex;
        return this.iterator.next();
    }
}

