/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.cachingcontainer;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.cachingcontainer.CachingContainerIterator;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.datastructure.pair.Pair;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.cachingcontainer.ICachingContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.Optional;

public final class CachingContainer<E>
extends AbstractExtendedContainer<E>
implements ICachingContainer<E> {
    private static final String AUTO_ID_PREFIX = "Z";
    private long autoIdCounter = 1L;
    private final LinkedList<Pair<String, E>> elements = LinkedList.createEmpty();

    @Override
    public boolean containsWithId(String id) {
        return this.elements.containsAny(e -> ((String)e.getStoredElement1()).equals(id));
    }

    @Override
    public int getCount() {
        return this.elements.getCount();
    }

    @Override
    public String getIdOf(E element) {
        return (String)this.elements.getStoredFirst(e -> e.getStoredElement2().equals(element)).getStoredElement1();
    }

    public Optional<String> getOptionalIdOf(E element) {
        Optional<Pair> pair = this.elements.getOptionalStoredFirst(e -> e.getStoredElement2() == element);
        if (pair.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((String)pair.get().getStoredElement1());
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        return this.elements.getStoredAtOneBasedIndex(oneBasedIndex).getStoredElement2();
    }

    @Override
    public E getStoredById(String id) {
        return (E)this.elements.getStoredFirst(e -> ((String)e.getStoredElement1()).equals(id)).getStoredElement2();
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return new CachingContainerIterator(this.elements.iterator());
    }

    @Override
    public String registerAndGetId(E element) {
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        this.assertDoesNotContain(element);
        String id = this.createNextAutoId();
        this.elements.addAtEnd(new Pair<String, E>(id, element));
        return id;
    }

    @Override
    public void registerAtId(String id, E element) {
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        this.assertDoesNotContainId(id);
        this.assertDoesNotContain(element);
        this.elements.addAtEnd(new Pair<String, E>(id, element));
    }

    @Override
    public String registerIfNotRegisteredAndGetId(E element) {
        Optional<Pair> pair = this.elements.getOptionalStoredFirst(e -> e.hasElement2(element));
        if (pair.isEmpty()) {
            Validator.assertThat(element).thatIsNamed("element").isNotNull();
            String id = this.createNextAutoId();
            this.elements.addAtEnd(new Pair<String, E>(id, element));
            return id;
        }
        return (String)pair.get().getStoredElement1();
    }

    private void assertDoesNotContain(E element) {
        if (this.contains(element)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "contains already the given element '" + String.valueOf(element) + "'");
        }
    }

    private void assertDoesNotContainId(String id) {
        if (this.containsWithId(id)) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate("id", id, "is already used");
        }
    }

    private String createNextAutoId() {
        while (this.containsWithId(AUTO_ID_PREFIX + this.autoIdCounter)) {
            ++this.autoIdCounter;
        }
        long nextAutoId = this.autoIdCounter++;
        return String.valueOf(AUTO_ID_PREFIX + nextAutoId);
    }
}

