/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.containerview;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.containerview.ArrayContainerView;
import ch.nolix.core.container.containerview.MultiContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class ContainerView<E>
extends AbstractExtendedContainer<E> {
    private final IContainer<E> internalContainer;

    private ContainerView(IContainer<E> container) {
        Validator.assertThat(container).thatIsNamed("container").isNotNull();
        this.internalContainer = container;
    }

    public static <E2> ContainerView<E2> forArray(E2[] array, E2[] ... arrays) {
        MultiContainerView<E2> container = MultiContainerView.forArray(array, arrays);
        return new ContainerView<E2>(container);
    }

    public static <E2> ContainerView<E2> forElementAndArray(E2 element, E2[] array) {
        Object[] arrayWithElement = new Object[]{element};
        MultiContainerView<Object> container = MultiContainerView.forArray(arrayWithElement, new Object[][]{array});
        return new ContainerView<Object>(container);
    }

    public static <E2> ContainerView<E2> forEmpty() {
        ImmutableList container = ImmutableList.createEmpty();
        return new ContainerView(container);
    }

    @SafeVarargs
    public static <E2> ContainerView<E2> forIterable(Iterable<? extends E2> iterable, Iterable<? extends E2> ... iterables) {
        MultiContainerView<? extends E2> container = MultiContainerView.forIterable(iterable, iterables);
        return new ContainerView<E2>(container);
    }

    @SafeVarargs
    public static <E2> ContainerView<E2> forIterableAndElement(Iterable<? extends E2> iterable, E2 element, E2 ... elements) {
        MultiContainerView<? extends E2> container = MultiContainerView.forIterable(iterable, ImmutableList.withElement(element, new Object[0]), ArrayContainerView.forArray(elements));
        return new ContainerView<E2>(container);
    }

    public boolean equals(Object object) {
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return this.containsExactlyInSameOrder(iterable);
        }
        return false;
    }

    @Override
    public int getCount() {
        return this.internalContainer.getCount();
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        return this.internalContainer.getStoredAtOneBasedIndex(oneBasedIndex);
    }

    public int hashCode() {
        return this.internalContainer.hashCode();
    }

    @Override
    public boolean isMaterialized() {
        return this.internalContainer.isMaterialized();
    }

    @Override
    public CopyableIterator<E> iterator() {
        return this.internalContainer.iterator();
    }

    public String toString() {
        return this.internalContainer.toString();
    }
}

