/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.containerview;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class MultiContainerViewIterator<E>
implements CopyableIterator<E> {
    private final CopyableIterator<IContainer<E>> mainIterator;
    private CopyableIterator<E> currentSubIterator;

    private MultiContainerViewIterator(IContainer<IContainer<E>> containers) {
        this.mainIterator = containers.iterator();
        if (this.mainIterator.hasNext()) {
            this.currentSubIterator = ((IContainer)this.mainIterator.next()).iterator();
        }
        this.forwardSubIteratorToNextOrEnd();
    }

    private MultiContainerViewIterator(CopyableIterator<IContainer<E>> mainIterator, CopyableIterator<E> currentIterator) {
        this.mainIterator = mainIterator;
        this.currentSubIterator = currentIterator;
    }

    public static <E2> MultiContainerViewIterator<E2> forContainers(IContainer<IContainer<E2>> containers) {
        return new MultiContainerViewIterator(containers);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return new MultiContainerViewIterator<E>((CopyableIterator)this.mainIterator.getCopy(), (CopyableIterator)this.currentSubIterator.getCopy());
    }

    @Override
    public boolean hasNext() {
        return this.currentSubIterator != null && this.currentSubIterator.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next element");
        }
        Object element = this.currentSubIterator.next();
        this.forwardSubIteratorToNextOrEnd();
        return element;
    }

    private void forwardSubIteratorToNextOrEnd() {
        while (this.currentSubIterator != null && !this.currentSubIterator.hasNext()) {
            this.currentSubIterator = this.mainIterator.hasNext() ? ((IContainer)this.mainIterator.next()).iterator() : null;
        }
    }
}

