/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.datastructure.pair;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.datastructure.pair.IPair;

public final class Pair<E1, E2>
implements IPair<E1, E2> {
    private final E1 element1;
    private final E2 element2;

    public Pair(E1 element1, E2 element2) {
        Validator.assertThat(element1).thatIsNamed("element 1").isNotNull();
        Validator.assertThat(element2).thatIsNamed("element 2").isNotNull();
        this.element1 = element1;
        this.element2 = element2;
    }

    @Override
    public E1 getStoredElement1() {
        return this.element1;
    }

    @Override
    public E2 getStoredElement2() {
        return this.element2;
    }

    @Override
    public boolean hasElement1(Object object) {
        return this.element1 == object;
    }

    @Override
    public boolean hasElement2(Object object) {
        return this.element2 == object;
    }

    public String toString() {
        return "(" + String.valueOf(this.getStoredElement1()) + "," + String.valueOf(this.getStoredElement2()) + ")";
    }
}

