/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.document.xml;

import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.xml.XmlAttribute;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.xml.IMutableXmlNode;
import ch.nolix.coreapi.document.xml.IXmlAttribute;
import ch.nolix.coreapi.document.xml.IXmlNode;

public final class MutableXmlNode
implements IMutableXmlNode {
    private String name;
    private String value;
    private final LinkedList<IXmlAttribute> attributes = LinkedList.createEmpty();
    private final LinkedList<IMutableXmlNode> childNodes = LinkedList.createEmpty();

    private MutableXmlNode() {
    }

    public static MutableXmlNode createBlankMutableXmlNode() {
        return new MutableXmlNode();
    }

    public static MutableXmlNode fromXmlNode(IXmlNode<?> pXmlNode) {
        MutableXmlNode mutableXmlNode = new MutableXmlNode();
        if (pXmlNode.hasName()) {
            mutableXmlNode.setName(pXmlNode.getName());
        }
        mutableXmlNode.addAttributes(pXmlNode.getAttributes());
        for (IXmlNode cn : pXmlNode.getStoredChildNodes()) {
            mutableXmlNode.addChildNode(MutableXmlNode.fromXmlNode(cn));
        }
        if (pXmlNode.hasValue()) {
            mutableXmlNode.setValue((String)pXmlNode.getValue());
        }
        return mutableXmlNode;
    }

    private static String toFormatedString(IMutableXmlNode mutableXmlNode, int leadingTabulatorCount) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringTool.createTabs(leadingTabulatorCount)).append('<').append(mutableXmlNode.getName());
        if (mutableXmlNode.containsAttributes()) {
            stringBuilder.append(' ').append(mutableXmlNode.getAttributes().toStringWithSeparator(' '));
        }
        stringBuilder.append('>');
        if (mutableXmlNode.hasValue()) {
            if (!mutableXmlNode.hasMixedContent()) {
                stringBuilder.append((String)mutableXmlNode.getValue());
            } else {
                stringBuilder.append('\n').append(StringTool.createTabs(leadingTabulatorCount + 1)).append((String)mutableXmlNode.getValue()).append('\n');
            }
        }
        if (mutableXmlNode.containsChildNodes()) {
            for (IMutableXmlNode cn : mutableXmlNode.getStoredChildNodes()) {
                stringBuilder.append('\n').append(MutableXmlNode.toFormatedString(cn, leadingTabulatorCount + 1));
            }
            stringBuilder.append('\n');
        }
        if (mutableXmlNode.containsChildNodes()) {
            stringBuilder.append(StringTool.createTabs(leadingTabulatorCount));
        }
        stringBuilder.append("</").append(mutableXmlNode.getName()).append('>');
        return stringBuilder.toString();
    }

    @Override
    public MutableXmlNode addAttribute(IXmlAttribute attribute) {
        this.attributes.addAtEnd(attribute);
        return this;
    }

    @Override
    public MutableXmlNode addAttributes(IXmlAttribute attribute, IXmlAttribute ... attributes) {
        this.addAttribute(attribute);
        return this.addAttributes(ContainerView.forArray(attributes, new IXmlAttribute[0][]));
    }

    public MutableXmlNode addAttributes(Iterable<IXmlAttribute> attributes) {
        this.attributes.addAtEnd(attributes);
        return this;
    }

    @Override
    public IMutableXmlNode addAttributeWithNameAndValue(String name, String value) {
        return this.addAttribute(new XmlAttribute(name, value));
    }

    @Override
    public MutableXmlNode addChildNode(IMutableXmlNode childNode) {
        this.childNodes.addAtEnd(childNode);
        return this;
    }

    @Override
    public MutableXmlNode addChildNodes(IMutableXmlNode childNode, IMutableXmlNode ... childNodes) {
        this.addChildNode(childNode);
        return this.addChildNodes(ContainerView.forArray(childNodes, new IMutableXmlNode[0][]));
    }

    public MutableXmlNode addChildNodes(Iterable<IMutableXmlNode> childNodes) {
        this.childNodes.addAtEnd(childNodes);
        return this;
    }

    @Override
    public boolean containsAttributes() {
        return this.attributes.containsAny();
    }

    @Override
    public boolean containsChildNodes() {
        return this.childNodes.containsAny();
    }

    @Override
    public IContainer<IXmlAttribute> getAttributes() {
        return this.attributes;
    }

    public int getAttributeCount() {
        return this.attributes.getCount();
    }

    public int getChildNodeCount() {
        return this.childNodes.getCount();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "name");
        }
        return this.name;
    }

    @Override
    public IContainer<IMutableXmlNode> getStoredChildNodes() {
        return this.childNodes;
    }

    @Override
    public String getValue() {
        this.supposeHasValue();
        return this.value;
    }

    @Override
    public boolean hasMixedContent() {
        return this.hasValue() && this.containsChildNodes();
    }

    @Override
    public boolean hasName() {
        return this.name != null;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    public IMutableXmlNode removeAttributes() {
        this.attributes.clear();
        return this;
    }

    public IMutableXmlNode removeChildNodes() {
        this.childNodes.clear();
        return this;
    }

    @Override
    public void removeName() {
        this.name = null;
    }

    @Override
    public void removeValue() {
        this.value = null;
    }

    @Override
    public IMutableXmlNode setName(String name) {
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        this.name = name;
        return this;
    }

    @Override
    public IMutableXmlNode setValue(String value) {
        Validator.assertThat(value).isNotEmpty();
        this.value = value;
        return this;
    }

    public String toFormatedString() {
        return MutableXmlNode.toFormatedString(this, 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<').append(this.getName());
        if (this.containsAttributes()) {
            stringBuilder.append(' ').append(this.getAttributes().toStringWithSeparator(' '));
        }
        stringBuilder.append('>');
        if (this.hasValue()) {
            stringBuilder.append(this.getValue());
        }
        if (this.containsChildNodes()) {
            for (IMutableXmlNode cn : this.getStoredChildNodes()) {
                stringBuilder.append(cn.toString());
            }
        }
        stringBuilder.append("</").append(this.getName()).append('>');
        return stringBuilder.toString();
    }

    private void supposeHasValue() {
        if (!this.hasValue()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "value");
        }
    }
}

