/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.environment.localcomputer;

import javax.swing.JOptionPane;

public final class PopupWindowProvider {
    private static final String ERROR_WINDOW_TITLE = "Error";
    private static final String MESSAGE_WINDOW_TITLE = "Message";
    private static final String REQUEST_WINDOW_TITLE = "Request";

    private PopupWindowProvider() {
    }

    public static void showErrorWindow(String errorMessage) {
        JOptionPane.showMessageDialog(null, errorMessage, ERROR_WINDOW_TITLE, 0);
    }

    public static void showErrorWindow(Throwable error) {
        String title;
        StringBuilder textStringBuilder = new StringBuilder();
        if (error == null) {
            title = "Exception";
            textStringBuilder.append("An exception, that is null, occured.");
        } else {
            title = error.getClass().getSimpleName();
            if (error.getMessage() != null && !error.getMessage().isEmpty()) {
                textStringBuilder.append(error.getMessage() + "\n\n");
            }
            StackTraceElement[] stackTraceElementArray = error.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                String[] classPath = ste.getClassName().split("\\.");
                textStringBuilder.append(classPath[classPath.length - 1]);
                if (ste.getLineNumber() > 0) {
                    textStringBuilder.append(" (line " + ste.getLineNumber() + ")");
                }
                textStringBuilder.append('\n');
                ++n2;
            }
        }
        JOptionPane.showMessageDialog(null, textStringBuilder.toString(), title, 0);
    }

    public static void showMessageWindow(String message) {
        JOptionPane.showMessageDialog(null, message, MESSAGE_WINDOW_TITLE, 1);
    }

    public static boolean showRequestWindow(String question) {
        int result = JOptionPane.showConfirmDialog(null, question, REQUEST_WINDOW_TITLE, 0);
        return result == 0;
    }
}

