/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.logging;

import ch.nolix.core.errorcontrol.errormapping.StackTraceMapper;
import ch.nolix.core.independent.list.ImmutableList;
import ch.nolix.coreapi.errorcontrol.logging.HarmLevel;

public final class LogEntry {
    private static final StackTraceMapper STACK_TRACE_MAPPER = new StackTraceMapper();
    private final String message;
    private final HarmLevel harmLevel;
    private final long creationTimeInMillisecondsSince1970 = System.currentTimeMillis();
    private final ImmutableList<String> additionalInfoLines;

    private LogEntry(HarmLevel harmLevel, String message, String[] additionalInfoLines) {
        this.harmLevel = harmLevel == null ? HarmLevel.ERROR : harmLevel;
        this.message = message == null ? "Error." : message;
        this.additionalInfoLines = additionalInfoLines == null ? ImmutableList.createEmptyList() : ImmutableList.withElements(additionalInfoLines);
    }

    public static LogEntry forError(Throwable error) {
        return new LogEntry(HarmLevel.ERROR, LogEntry.getMessageFromError(error), LogEntry.getAdditionalInfoLinesFromError(error));
    }

    public static LogEntry withMessageAndHarmLevel(String message, HarmLevel harmLevel) {
        return new LogEntry(harmLevel, message, new String[0]);
    }

    private static String[] getAdditionalInfoLinesFromError(Throwable error) {
        return STACK_TRACE_MAPPER.mapErrorToStackTrace(error);
    }

    private static String getMessageFromError(Throwable error) {
        if (error == null) {
            return "An error occured.";
        }
        String message = error.getMessage();
        if (message == null || message.isBlank()) {
            return "An error occured.";
        }
        return message;
    }

    public ImmutableList<String> getAdditionalInfoLines() {
        return this.additionalInfoLines;
    }

    public long getCreationTimeInMillisecondsSince1970() {
        return this.creationTimeInMillisecondsSince1970;
    }

    public HarmLevel getHarmLevel() {
        return this.harmLevel;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.valueOf((Object)this.getHarmLevel()) + ": " + this.getMessage();
    }
}

