/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.math.algebra;

import ch.nolix.core.commontypetool.arraytool.ArrayTool;
import ch.nolix.core.commontypetool.doubletool.DoubleTool;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.independent.math.NumberComparator;
import ch.nolix.core.math.algebra.Vector;
import ch.nolix.core.math.main.Calculator;
import ch.nolix.coreapi.commontypetool.arraytool.IArrayTool;
import ch.nolix.coreapi.commontypetool.doubletool.IDoubleTool;

public final class Polynom {
    public static final Polynom EMPTY_POLYNOM = new Polynom();
    public static final String DEFAULT_PARAMTER_SYMBOL = "x";
    private static final IArrayTool ARRAY_TOOL = new ArrayTool();
    private static final IDoubleTool DOUBLE_TOOL = new DoubleTool();
    private Polynom derivedPolynom;
    private final double[] coefficients;

    private Polynom() {
        this.coefficients = new double[0];
    }

    private Polynom(double[] coefficientArray) {
        Validator.assertThat(coefficientArray).thatIsNamed("coefficient array").isNotNull();
        if (coefficientArray.length > 0) {
            Validator.assertThat(coefficientArray[0]).thatIsNamed("highest coefficient").isNotEqualTo(0.0);
        }
        this.coefficients = coefficientArray;
    }

    public static Polynom withCoefficient(double coefficient, double ... coefficients) {
        return new Polynom(ARRAY_TOOL.createArrayWithValue(coefficient, coefficients));
    }

    public static Polynom withCoefficients(double[] coefficients) {
        return new Polynom(coefficients);
    }

    public boolean equals(Object object) {
        Polynom polynom;
        return object instanceof Polynom && this.equals(polynom = (Polynom)object);
    }

    public double getCoefficientForDegree(int degree) {
        Validator.assertThat(degree).thatIsNamed("degree").isBetween(0, this.getDegree());
        return this.coefficients[this.coefficients.length - degree - 1];
    }

    public Polynom getDerived() {
        return this.getDerived(1);
    }

    public Polynom getDerived(int deriveCount) {
        if (deriveCount == 1) {
            if (this.derivedPolynom == null) {
                this.derivedPolynom = this.calculateDerived(1);
            }
            return this.derivedPolynom;
        }
        return this.calculateDerived(deriveCount);
    }

    public int getDegree() {
        return this.coefficients.length - 1;
    }

    public Polynom getIntegrated() {
        return this.getIntegrated(1);
    }

    public Polynom getIntegrated(int integrationCount) {
        Validator.assertThat(integrationCount).thatIsNamed("integration count").isNotNegative();
        int degree = this.getDegree();
        int integratedDegree = degree + integrationCount;
        double[] integratedCoefficients = new double[integratedDegree + 1];
        int i = 0;
        while (i < integratedDegree) {
            if (NumberComparator.isZero(this.coefficients[i])) {
                integratedCoefficients[i] = 0.0;
            } else {
                double integratedCoefficient = this.coefficients[i];
                int j = degree - i + 1;
                while (j < integratedDegree - i + 1) {
                    integratedCoefficient /= (double)j;
                    ++j;
                }
                integratedCoefficients[i] = integratedCoefficient;
            }
            ++i;
        }
        return new Polynom(integratedCoefficients);
    }

    public double getSlopeAt(double x) {
        return this.getDerived().getValueAt(x);
    }

    public double getValueAt(double x) {
        if (this.isZeroPolynom()) {
            return 0.0;
        }
        return this.getValueAtWhenIsNotZeroPolynom(x);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean hasSameDegreeAs(Polynom polynom) {
        return polynom != null && this.getDegree() == polynom.getDegree();
    }

    public boolean isZeroPolynom() {
        return this.coefficients.length == 0;
    }

    public double[] toArray() {
        return (double[])this.coefficients.clone();
    }

    public String toString() {
        return this.toString(DEFAULT_PARAMTER_SYMBOL);
    }

    public String toString(String parameterSymbol) {
        Validator.assertThat(parameterSymbol).thatIsNamed("parameter symbol").isNotBlank();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(parameterSymbol + "->");
        this.appendHigherCoefficientsTo(stringBuilder, parameterSymbol);
        this.appendLinearCoefficientTo(stringBuilder, parameterSymbol);
        this.appendConstantTo(stringBuilder);
        return stringBuilder.toString();
    }

    public Vector toVector() {
        return Vector.withValues(this.coefficients);
    }

    private Polynom calculateDerived(int deriveCount) {
        Validator.assertThat(deriveCount).thatIsNamed("derive count").isNotNegative();
        if (deriveCount == 0) {
            return this;
        }
        int degree = this.getDegree();
        int derivedDegree = Calculator.getMax(0, degree - deriveCount);
        double[] derivedCoefficients = new double[derivedDegree + 1];
        int derivedCoefficientIndex = 0;
        while (derivedCoefficientIndex <= derivedDegree) {
            double derivedCoefficient = this.coefficients[derivedCoefficientIndex];
            int j = degree - derivedCoefficientIndex;
            while (j > derivedDegree - derivedCoefficientIndex) {
                derivedCoefficient *= (double)j;
                --j;
            }
            derivedCoefficients[derivedCoefficientIndex] = derivedCoefficient;
            ++derivedCoefficientIndex;
        }
        return new Polynom(derivedCoefficients);
    }

    private boolean equals(Polynom polynom) {
        if (!this.hasSameDegreeAs(polynom)) {
            return false;
        }
        int i = 0;
        while (i < this.coefficients.length) {
            if (!NumberComparator.areEqual(this.coefficients[i], polynom.coefficients[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private double getValueAtWhenIsNotZeroPolynom(double x) {
        double value = this.coefficients[0];
        double base = 1.0;
        int i = 1;
        while (i < this.coefficients.length) {
            value += this.coefficients[i] * (base *= x);
            ++i;
        }
        return value;
    }

    private void appendConstantTo(StringBuilder stringBuilder) {
        if (this.coefficients.length == 0) {
            stringBuilder.append("0.0");
        } else {
            double constant = this.coefficients[this.coefficients.length - 1];
            if (!NumberComparator.isZero(constant)) {
                if (this.coefficients.length > 1 && constant > 0.0) {
                    stringBuilder.append("+");
                }
                stringBuilder.append(DOUBLE_TOOL.toString(constant));
            }
        }
    }

    private void appendHigherCoefficientsTo(StringBuilder stringBuilder, String parameterSymbol) {
        int degree = this.getDegree();
        int i = 0;
        while (i < degree - 1) {
            double coefficient = this.coefficients[i];
            if (!NumberComparator.isZero(coefficient)) {
                if (i > 0 && coefficient > 0.0) {
                    stringBuilder.append('+');
                }
                if (!NumberComparator.isOne(coefficient)) {
                    stringBuilder.append(DOUBLE_TOOL.toString(coefficient));
                }
                int coefficientDegree = degree - i;
                stringBuilder.append(parameterSymbol + "^" + coefficientDegree);
            }
            ++i;
        }
    }

    private void appendLinearCoefficientTo(StringBuilder stringBuilder, String parameterSymbol) {
        double linearCoefficient;
        if (this.coefficients.length > 1 && !NumberComparator.isZero(linearCoefficient = this.coefficients[this.coefficients.length - 2])) {
            if (this.coefficients.length > 2 && linearCoefficient > 0.0) {
                stringBuilder.append("+");
            }
            stringBuilder.append(DOUBLE_TOOL.toString(linearCoefficient) + parameterSymbol);
        }
    }
}

